/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class DateConverter
extends Converter {
    static final SimpleDateFormat SDF_DEFAULT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Date source;

    public DateConverter(Date source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Date", "java.Util.Boolean", this.convertToString());
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.lang.Byte", this.convertToString());
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.lang.Short", this.convertToString());
    }

    @Override
    public Integer convertToInt() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.lang.Integer", this.convertToString());
    }

    @Override
    public Long convertToLong() {
        return this.source.getTime();
    }

    @Override
    public Float convertToFloat() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.lang.Float", this.convertToString());
    }

    @Override
    public Double convertToDouble() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.lang.Double", this.convertToString());
    }

    @Override
    public String convertToString() {
        return SDF_DEFAULT.format(this.source);
    }

    @Override
    public Date convertToDate() {
        return this.source;
    }

    @Override
    public BigDecimal convertToDecimal() {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.util.Date", "java.math.BigDecimal", this.convertToString());
    }

    @Override
    public String convertToJsonString() {
        return "new Date(" + this.source.getTime() + ")";
    }
}

