/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class DecimalConverter
extends Converter {
    private BigDecimal source;

    public DecimalConverter(BigDecimal source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public Byte convertToByte() {
        return this.source.byteValue();
    }

    @Override
    public Short convertToShort() {
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() {
        return this.source.intValue();
    }

    @Override
    public Long convertToLong() {
        return this.source.longValue();
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source.floatValue());
    }

    @Override
    public Double convertToDouble() {
        return this.source.doubleValue();
    }

    @Override
    public String convertToString() {
        return this.source.toPlainString();
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.math.BigDecimal", "java.util.Date", this.convertToString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return this.source;
    }

    @Override
    public String convertToJsonString() {
        return this.convertToString();
    }
}

