/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class DoubleConverter
extends Converter {
    private Double source;

    public DoubleConverter(Double source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source != 0.0;
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        if (this.source > 127.0 || this.source < -128.0) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Double", "java.lang.Byte", this.convertToString());
        }
        return this.source.byteValue();
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        if (this.source > 32767.0 || this.source < -32768.0) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Double", "java.lang.Short", this.convertToString());
        }
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() throws JDiyConvertException {
        if (this.source > 2.147483647E9 || this.source < -2.147483648E9) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Double", "java.lang.Integer", this.convertToString());
        }
        return this.source.intValue();
    }

    @Override
    public Long convertToLong() {
        return Math.round(this.source);
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source.floatValue());
    }

    @Override
    public Double convertToDouble() {
        return this.source;
    }

    @Override
    public String convertToString() {
        return this.source.toString();
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Double", "java.util.Date", this.convertToString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return BigDecimal.valueOf(this.source);
    }

    @Override
    public String convertToJsonString() {
        return this.convertToString();
    }
}

