/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class FloatConverter
extends Converter {
    private Float source;

    public FloatConverter(Float source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source.floatValue() != 0.0f;
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        if (this.source.floatValue() > 127.0f || this.source.floatValue() < -128.0f) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Float", "java.lang.Byte", this.convertToString());
        }
        return this.source.byteValue();
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        if (this.source.floatValue() > 32767.0f || this.source.floatValue() < -32768.0f) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Float", "java.lang.Short", this.convertToString());
        }
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() {
        return Math.round(this.source.floatValue());
    }

    @Override
    public Long convertToLong() {
        return this.convertToInt().longValue();
    }

    @Override
    public Float convertToFloat() {
        return this.source;
    }

    @Override
    public Double convertToDouble() {
        return this.source.doubleValue();
    }

    @Override
    public String convertToString() {
        return this.source.toString();
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Float", "java.util.Date", this.convertToString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return BigDecimal.valueOf(this.source.floatValue());
    }

    @Override
    public String convertToJsonString() {
        return this.convertToString();
    }
}

