/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class IntegerConverter
extends Converter {
    private Integer source;

    public IntegerConverter(Integer source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source != 0;
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        if (this.source > 127 || this.source < -128) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Integer", "java.lang.Byte", this.convertToString());
        }
        return this.source.byteValue();
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        if (this.source > Short.MAX_VALUE || this.source < Short.MIN_VALUE) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Integer", "java.lang.Short", this.convertToString());
        }
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() {
        return this.source;
    }

    @Override
    public Long convertToLong() {
        return this.source.longValue();
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source.floatValue());
    }

    @Override
    public Double convertToDouble() {
        return this.source.doubleValue();
    }

    @Override
    public String convertToString() {
        return this.source.toString();
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.Lang.Integer", "java.util.Date", this.convertToString());
    }

    @Override
    public BigDecimal convertToDecimal() {
        return BigDecimal.valueOf(this.source.intValue());
    }

    @Override
    public String convertToJsonString() {
        return this.convertToString();
    }
}

