/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class LongConverter
extends Converter {
    private Long source;

    public LongConverter(Long source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        return this.source != 0L;
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        if (this.source > 127L || this.source < -128L) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Long", "java.lang.Byte", this.convertToString());
        }
        return this.source.byteValue();
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        if (this.source > 32767L || this.source < -32768L) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Long", "java.lang.Short", this.convertToString());
        }
        return this.source.shortValue();
    }

    @Override
    public Integer convertToInt() throws JDiyConvertException {
        if (this.source > Integer.MAX_VALUE || this.source < Integer.MIN_VALUE) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.Long", "java.lang.Integer", this.convertToString());
        }
        return this.source.intValue();
    }

    @Override
    public Long convertToLong() {
        return this.source;
    }

    @Override
    public Float convertToFloat() {
        return Float.valueOf(this.source.floatValue());
    }

    @Override
    public Double convertToDouble() {
        return this.source.doubleValue();
    }

    @Override
    public String convertToString() {
        return this.source.toString();
    }

    @Override
    public Date convertToDate() {
        return new Date(this.source);
    }

    @Override
    public BigDecimal convertToDecimal() {
        return BigDecimal.valueOf(this.source);
    }

    @Override
    public String convertToJsonString() {
        return this.convertToString();
    }
}

