/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.convert;

import java.math.BigDecimal;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.convert.DateConverter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.res.Locale;

class StringConverter
extends Converter {
    private String source;

    public StringConverter(String source) {
        this.source = source;
    }

    @Override
    public boolean convertToBoolean() {
        String s = this.source.trim();
        return !"".equals(s) && !"false".equalsIgnoreCase(s) && !"0".equalsIgnoreCase(s) && !"null".equalsIgnoreCase(s) && !"no".equalsIgnoreCase(s) && !"off".equalsIgnoreCase(s) && !"\u5426".equalsIgnoreCase(s);
    }

    @Override
    public Byte convertToByte() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1");
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Byte", this.convertToString());
        }
    }

    @Override
    public Short convertToShort() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1");
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Short", this.convertToString());
        }
    }

    @Override
    public Integer convertToInt() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1");
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Integer", this.convertToString());
        }
    }

    @Override
    public Long convertToLong() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1");
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Long", this.convertToString());
        }
    }

    @Override
    public Float convertToFloat() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\d+)(\\.*)(\\d*)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1$2$3");
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Float", this.convertToString());
        }
    }

    @Override
    public Double convertToDouble() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\d+)(\\.*)(\\d*)(.|\r|\n)*$");
        Matcher matcher = pattern.matcher(this.source);
        String str = matcher.replaceAll("$1$2$3");
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.lang.Double", this.convertToString());
        }
    }

    @Override
    public String convertToString() {
        return this.source;
    }

    @Override
    public Date convertToDate() throws JDiyConvertException {
        if ("".equals(this.source)) {
            return null;
        }
        try {
            if (Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return DateConverter.SDF_DEFAULT.parse(this.source);
            }
            if (Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(this.source);
            }
            if (Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}").matcher(this.source).matches()) {
                return new java.sql.Date(new SimpleDateFormat("yyyy-MM-dd").parse(this.source).getTime());
            }
            if (Pattern.compile("^\\d{1,2}:\\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new Time(new SimpleDateFormat("HH:mm:ss").parse(this.source).getTime());
            }
            if (Pattern.compile("^\\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new Time(new SimpleDateFormat("HH:mm").parse(this.source).getTime());
            }
            if (Pattern.compile("^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$").matcher(this.source).matches()) {
                return new java.sql.Date(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5").parse(this.source).getTime());
            }
            if (Pattern.compile("^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss").parse(this.source);
            }
            if (Pattern.compile("^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm").parse(this.source);
            }
            if (Pattern.compile("^\\d{1,2}/\\d{1,2}/\\d{4}$").matcher(this.source).matches()) {
                return new java.sql.Date(new SimpleDateFormat("MM/dd/yyyy").parse(this.source).getTime());
            }
            if (Pattern.compile("^\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(this.source);
            }
            if (Pattern.compile("^\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}$").matcher(this.source).matches()) {
                return new SimpleDateFormat("MM/dd/yyyy HH:mm").parse(this.source);
            }
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr"), "java.lang.String", "java.util.Date", this.convertToString());
        }
        catch (ParseException e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.util.Date", this.convertToString());
        }
    }

    @Override
    public BigDecimal convertToDecimal() {
        try {
            return new BigDecimal(this.source);
        }
        catch (Exception e) {
            throw new JDiyConvertException(Locale.DBG.getString("err.converter.convertErr") + "\r\n" + e.toString(), "java.lang.String", "java.math.Decimal", this.convertToString());
        }
    }

    @Override
    public String convertToJsonString() {
        return "\"" + this.source.replaceAll("\"", "\\\\\"").replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n") + "\"";
    }
}

