/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.jdiy.core.db.DbEngine;
import net.jdiy.core.ex.JDiyConfigException;
import net.jdiy.core.ex.JDiyConnectionException;
import net.jdiy.core.res.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnPool {
    private Driver driver = null;
    private int inUse = 0;
    private List<Connection> Connections = new ArrayList<Connection>();
    private DbEngine db;
    static final Logger log = LoggerFactory.getLogger(ConnPool.class);

    public ConnPool(DbEngine db) {
        this.db = db;
    }

    public synchronized void releaseConnection(Connection con) throws JDiyConfigException {
        this.create();
        if (con == null) {
            return;
        }
        if (this.db.getPoolLimit() >= 0) {
            this.Connections.add(con);
        } else {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (--this.inUse < 0) {
            this.inUse = 0;
        }
    }

    public synchronized Connection getConnection() throws JDiyConnectionException {
        this.create();
        Connection con = null;
        int waited = 0;
        while (con == null) {
            if (this.Connections.size() > 0) {
                con = this.Connections.get(0);
                this.Connections.remove(0);
                try {
                    if (!con.isClosed() && this.testConnection(con)) continue;
                    con = this.getConnection();
                }
                catch (SQLException e) {
                    log.warn(e.getMessage());
                }
                continue;
            }
            if (this.db.getPoolLimit() <= 0 || this.inUse + this.Connections.size() < this.db.getPoolLimit()) {
                con = this.newConnection();
                continue;
            }
            if ("WAIT".equals(this.db.getMaxed())) {
                try {
                    this.wait(1L);
                    ++waited;
                }
                catch (InterruptedException e) {
                    log.error(Locale.DBG.getString("log.ConnPool.waitError"), (Object)e.getMessage());
                }
                continue;
            }
            String s = Locale.DBG.getString("log.ConnPool.limitError");
            log.error(s, (Object)this.db.getPoolLimit());
            throw new JDiyConnectionException(s, String.valueOf(this.db.getPoolLimit()));
        }
        if (waited > 0) {
            log.warn(Locale.DBG.getString("log.ConnPool.waitWarn"), (Object)this.db.getPoolLimit(), (Object)waited);
        }
        ++this.inUse;
        return con;
    }

    public DbEngine getEngine() {
        return this.db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.driver == null) {
            return;
        }
        for (Connection c : this.Connections) {
            try {
                c.close();
            }
            catch (SQLException e) {
                log.warn(Locale.DBG.getString("log.ConnPool.closeErr"), (Object)e.toString());
            }
        }
        this.Connections.clear();
        try {
            DriverManager.deregisterDriver(this.driver);
            log.info(Locale.DBG.getString("log.ConnPool.destoried"), (Object)this.db.getDbUrl());
        }
        catch (SQLException ex) {
            log.warn(Locale.DBG.getString("log.ConnPool.closeWarn"), (Object)this.db.getDbUrl(), (Object)ex.toString());
        }
        finally {
            this.driver = null;
        }
    }

    private boolean testConnection(Connection conn) throws SQLException {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(this.db.getTestQuery());
            stmt.close();
            return true;
        }
        catch (SQLException se) {
            conn.close();
            se.printStackTrace();
            return false;
        }
    }

    private Connection newConnection() throws JDiyConnectionException {
        try {
            Properties prop = new Properties();
            if (!"".equals(this.db.getDbUid())) {
                prop.setProperty("user", this.db.getDbUid());
            }
            if (!"".equals(this.db.getDbUid())) {
                prop.setProperty("password", this.db.getDbPwd());
            }
            return DriverManager.getConnection(this.db.getDbUrl(), prop);
        }
        catch (Exception ex) {
            throw new JDiyConnectionException(Locale.DBG.getString("err.ConnPool.connectionErr"), ex.getMessage());
        }
    }

    private void create() throws JDiyConfigException {
        if (this.driver != null) {
            return;
        }
        try {
            this.driver = (Driver)Class.forName(this.db.getDbDriver()).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JDiyConfigException(Locale.DBG.getString("err.ConnPool.driverNotFound"), this.db.getDbDriver());
        }
        catch (Exception e) {
            throw new JDiyConfigException(Locale.DBG.getString("err.ConnPool.driverInvalid"), this.db.getDbDriver());
        }
        try {
            DriverManager.registerDriver(this.driver);
        }
        catch (SQLException e) {
            throw new JDiyConfigException(Locale.DBG.getString("err.ConnPool.driverRegister"), this.db.getDbUrl(), e.getMessage());
        }
        log.info(Locale.DBG.getString("log.ConnPool.registerOk"), (Object)this.db.getDbUrl());
    }
}

