/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.jdiy.core.Args;
import net.jdiy.core.Rs;
import net.jdiy.core.db.Record;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.res.Locale;

public abstract class DbEngine {
    public static final Map<String, String> _names = new HashMap<String, String>();
    protected String connName;
    protected String dbType;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUid;
    protected String dbPwd;
    protected String dbHost;
    protected int dbPort;
    protected String dbName;
    protected int poolLimit;
    protected String maxed;

    public static synchronized DbEngine getInstance(String connName, String dbType, String dbDriver, String dbUrl, String dbUid, String dbPwd, String dbHost, int dbPort, String dbName, int poolLimit, String maxed) {
        try {
            Class<?> C = Class.forName("net.jdiy.core.db.DbEngine" + _names.get(dbType.toLowerCase()));
            DbEngine dbEngine = (DbEngine)C.newInstance();
            dbEngine.connName = connName;
            dbEngine.dbType = dbType;
            dbEngine.dbDriver = dbDriver;
            dbEngine.dbUrl = dbUrl;
            dbEngine.dbUid = dbUid;
            dbEngine.dbPwd = dbPwd;
            dbEngine.dbHost = dbHost;
            dbEngine.dbPort = dbPort;
            dbEngine.dbName = dbName;
            dbEngine.poolLimit = poolLimit;
            dbEngine.maxed = maxed;
            return dbEngine;
        }
        catch (Exception ex) {
            throw new JDiyUnSupportException(Locale.DBG.getString("err.database.dbtype"), dbType);
        }
    }

    public Rs convertRs(ResultSetMetaData rsmd, ResultSet rs, String tableName, String[] primaryKeys, String dataPath) throws SQLException {
        int num = rsmd.getColumnCount();
        HashMap<String, DbField> lm = new HashMap<String, DbField>(num);
        for (int j = 1; j <= num; ++j) {
            DbField tdf = this.convertFieldDb(rsmd, j, rs);
            if (tdf == null) continue;
            lm.put(tdf.getName().toLowerCase(), tdf);
        }
        return new Record(this.connName, tableName, lm, dataPath, primaryKeys);
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getName() {
        return this.connName;
    }

    public String getTableName(ResultSetMetaData rsmd) throws SQLException {
        String tableName = "";
        int i = 1;
        while ("".equals(tableName) && i++ < rsmd.getColumnCount()) {
            tableName = rsmd.getTableName(i);
        }
        return tableName;
    }

    public abstract String getPageBreakSql(Args var1, String var2, int var3);

    abstract DbField convertFieldDb(ResultSetMetaData var1, int var2, ResultSet var3) throws SQLException;

    abstract String getDbDriver();

    abstract String getDbUrl();

    protected String getMaxed() {
        return this.maxed;
    }

    protected int getPoolLimit() {
        return this.poolLimit;
    }

    protected String getDbPwd() {
        return this.dbPwd;
    }

    protected String getDbUid() {
        return this.dbUid;
    }

    protected String getTestQuery() {
        return "SELECT 1";
    }

    protected boolean isReadonly(ResultSetMetaData rsmd, int sub) throws SQLException {
        return rsmd.isAutoIncrement(sub) || rsmd.isReadOnly(sub) || !rsmd.isWritable(sub) || !rsmd.isDefinitelyWritable(sub);
    }

    static {
        _names.put("mysql", "MySQL");
        _names.put("mssql", "MsSQL");
        _names.put("postgresql", "PostgreSQL");
        _names.put("oracle", "Oracle");
        _names.put("sqlite", "SQLite");
        _names.put("db2", "DB2");
    }
}

