/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.db;

import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.jdiy.core.Args;
import net.jdiy.core.db.DbEngine;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.res.Locale;

class DbEngineDB2
extends DbEngine {
    DbEngineDB2() {
    }

    @Override
    protected String getDbDriver() {
        if ("".equals(this.dbDriver)) {
            this.dbDriver = "com.ibm.db2.jcc.DB2Driver";
        }
        return this.dbDriver;
    }

    @Override
    protected String getDbUrl() {
        if ("".equals(this.dbUrl)) {
            this.dbUrl = "jdbc:db2://" + this.dbHost + ":" + this.dbPort + "/" + this.dbName;
        }
        return this.dbUrl;
    }

    @Override
    public String getPageBreakSql(Args args, String filter, int pageStart) {
        StringBuilder sql;
        String fl;
        String where;
        if (filter != null) {
            int j;
            int i;
            String scan = (filter = filter.trim()).toUpperCase();
            boolean startsWithOrder = scan.startsWith("ORDER ");
            where = startsWithOrder || scan.startsWith("GROUP ") ? " " + filter : " WHERE " + filter;
            int n = i = startsWithOrder ? 0 : scan.indexOf(" ORDER ");
            fl = i != -1 ? filter.substring(i, (j = scan.indexOf(" GROUP ", i)) > i ? j : filter.length()) : "";
        } else {
            fl = "";
            where = "";
        }
        if (args.getPageSize() > 0) {
            sql = new StringBuilder("SELECT * FROM (").append("SELECT rownumber() OVER(").append(fl).append(") AS ROW_NUM_FOR_PAGE_BREAK, ");
            sql.append(args.getCols().trim().equals("*") ? args.getTable() + ".*" : args.getCols());
            sql.append(" FROM ").append(args.getTable()).append(where).append(") AS a WHERE a.ROW_NUM_FOR_PAGE_BREAK >").append(pageStart).append(" AND a.ROW_NUM_FOR_PAGE_BREAK<=").append(pageStart + args.getPageSize());
        } else {
            sql = new StringBuilder("SELECT ").append(args.getCols()).append(" FROM ").append(args.getTable()).append(where);
        }
        return sql.toString();
    }

    @Override
    protected boolean isReadonly(ResultSetMetaData rsmd, int sub) throws SQLException {
        return rsmd.isAutoIncrement(sub);
    }

    @Override
    protected String getTestQuery() {
        return "VALUES 1";
    }

    @Override
    protected DbField convertFieldDb(ResultSetMetaData rsmd, int sub, ResultSet rs) throws SQLException {
        Object val;
        String name = rsmd.getColumnLabel(sub);
        if (name.equals("ROW_NUM_FOR_PAGE_BREAK")) {
            return null;
        }
        String realName = rsmd.getColumnName(sub);
        int fieldType = rsmd.getColumnType(sub);
        if (rs == null) {
            return new DbField(name, realName, fieldType, null, null, false, false);
        }
        boolean readonly = this.isReadonly(rsmd, sub);
        switch (fieldType) {
            case -16: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                val = rs.getObject(sub);
                break;
            }
            case -15: 
            case 1: {
                Object obj = rs.getObject(sub);
                val = obj == null ? null : obj.toString().trim();
                break;
            }
            case 2005: 
            case 2011: {
                val = DbEngineDB2.clobToString(rs.getClob(sub));
                break;
            }
            case 0: {
                val = null;
                break;
            }
            default: {
                throw new JDiyUnSupportException(Locale.DBG.getString("err.FieldDb.unSupport"), String.valueOf(rsmd.getColumnType(sub)), rsmd.getTableName(sub), name);
            }
        }
        return new DbField(name, realName, fieldType, val, val, false, readonly);
    }

    private static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader inStreamDoc = clob.getCharacterStream();
            char[] tempDoc = new char[(int)clob.length()];
            inStreamDoc.read(tempDoc);
            inStreamDoc.close();
            return new String(tempDoc);
        }
        catch (Exception e) {
            throw new JDiyUnSupportException(e.getMessage());
        }
    }
}

