/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.db;

import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.jdiy.core.Args;
import net.jdiy.core.db.DbEngine;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.res.Locale;

class DbEngineOracle
extends DbEngine {
    DbEngineOracle() {
    }

    @Override
    protected String getDbDriver() {
        if ("".equals(this.dbDriver)) {
            this.dbDriver = "oracle.jdbc.OracleDriver";
        }
        return this.dbDriver;
    }

    @Override
    protected String getDbUrl() {
        if ("".equals(this.dbUrl)) {
            this.dbUrl = "jdbc:oracle:thin:@" + this.dbHost + ":" + this.dbPort + ":" + this.dbName;
        }
        return this.dbUrl;
    }

    @Override
    protected String getTestQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getPageBreakSql(Args args, String filter, int pageStart) {
        StringBuilder sql;
        String where;
        String aWhere;
        if (filter != null) {
            String scan = (filter = filter.trim()).toUpperCase();
            if (scan.startsWith("ORDER ") || scan.startsWith("GROUP ")) {
                where = aWhere = " " + filter;
            } else {
                where = " WHERE " + filter;
                aWhere = " AND " + filter;
            }
        } else {
            aWhere = "";
            where = "";
        }
        if (args.getPageSize() < 1 || args.getAbsPage() <= 1) {
            sql = new StringBuilder("SELECT ").append(args.getCols()).append(" FROM ").append(args.getTable());
            if (args.getPageSize() > 0) {
                sql.append(" WHERE ").append("ROWNUM<=").append(args.getPageSize()).append(aWhere);
            } else {
                sql.append(where);
            }
        } else {
            sql = new StringBuilder("SELECT * FROM (").append(" SELECT A.*, ROWNUM ROW_NUM_FOR_PAGE_BREAK ").append(" FROM (SELECT ").append(args.getCols()).append(" FROM ").append(args.getTable()).append(where).append(") A").append(" WHERE ROWNUM <=").append(pageStart + args.getPageSize()).append(") WHERE ROW_NUM_FOR_PAGE_BREAK >").append(pageStart);
        }
        return sql.toString();
    }

    @Override
    protected boolean isReadonly(ResultSetMetaData rsmd, int sub) throws SQLException {
        return rsmd.isAutoIncrement(sub);
    }

    @Override
    protected DbField convertFieldDb(ResultSetMetaData rsmd, int sub, ResultSet rs) throws SQLException {
        Object val;
        String name = rsmd.getColumnLabel(sub);
        if (name.equals("ROW_NUM_FOR_PAGE_BREAK")) {
            return null;
        }
        String realName = rsmd.getColumnName(sub);
        int fieldType = rsmd.getColumnType(sub);
        if (rs == null) {
            return new DbField(name, realName, fieldType, null, null, false, false);
        }
        boolean readonly = this.isReadonly(rsmd, sub);
        switch (fieldType) {
            case -16: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                val = rs.getObject(sub);
                break;
            }
            case -1: {
                try {
                    val = rs.getObject(sub);
                    break;
                }
                catch (Exception ex) {
                    throw new JDiyUnSupportException(Locale.DBG.getString("err.FieldDb.unSupport") + "\n" + ex.getMessage(), String.valueOf(rsmd.getColumnType(sub)), rsmd.getTableName(sub), name);
                }
            }
            case -15: 
            case 1: {
                Object obj = rs.getObject(sub);
                val = obj == null ? null : obj.toString().trim();
                break;
            }
            case 2005: 
            case 2011: {
                val = DbEngineOracle.clobToString(rs.getClob(sub));
                break;
            }
            case 0: {
                val = null;
                break;
            }
            default: {
                throw new JDiyUnSupportException(Locale.DBG.getString("err.FieldDb.unSupport"), String.valueOf(rsmd.getColumnType(sub)), rsmd.getTableName(sub), name);
            }
        }
        return new DbField(name, realName, fieldType, val, val, false, readonly);
    }

    private static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader inStreamDoc = clob.getCharacterStream();
            char[] tempDoc = new char[(int)clob.length()];
            inStreamDoc.read(tempDoc);
            inStreamDoc.close();
            return new String(tempDoc);
        }
        catch (Exception e) {
            throw new JDiyUnSupportException(e.getMessage());
        }
    }
}

