/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.db;

import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.jdiy.core.Args;
import net.jdiy.core.db.DbEngine;
import net.jdiy.core.ex.JDiyConfigException;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.field.DbField;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Fs;

class DbEngineSQLite
extends DbEngine {
    DbEngineSQLite() {
    }

    @Override
    protected String getDbDriver() {
        if ("".equals(this.dbDriver)) {
            this.dbDriver = "org.sqlite.JDBC";
        }
        return this.dbDriver;
    }

    @Override
    protected String getDbUrl() {
        this.dbUrl = this.dbUrl.replaceFirst("jdbc:sqlite:", "");
        if ("".equals(this.dbUrl) || "$CLASSPATH:".equalsIgnoreCase(this.dbUrl)) {
            throw new JDiyConfigException(Locale.DBG.getString("err.native.sqliteUrl"));
        }
        String r = this.dbUrl;
        boolean c = r.toUpperCase().startsWith("$CLASSPATH");
        try {
            if (c) {
                r = Fs.getResource(r.substring(11)).getFile();
            }
        }
        catch (MalformedURLException ex) {
            throw new JDiyConfigException(ex.getMessage(), ex.getCause());
        }
        if (!new File(r).exists()) {
            throw new JDiyConfigException(Locale.DBG.getString("err.native.sqliteNotExists"), r);
        }
        return "jdbc:sqlite:" + r;
    }

    @Override
    public String getPageBreakSql(Args args, String filter, int pageStart) {
        String scan;
        String where = filter != null ? ((scan = (filter = filter.trim()).toUpperCase()).startsWith("ORDER ") || scan.startsWith("GROUP ") ? " " + filter : " WHERE " + filter) : "";
        StringBuilder sql = new StringBuilder("SELECT ").append(args.getCols()).append(" FROM ").append(args.getTable()).append(where);
        if (args.getPageSize() > 0) {
            sql.append(" LIMIT ").append(pageStart).append(", ").append(args.getPageSize());
        }
        return sql.toString();
    }

    @Override
    DbField convertFieldDb(ResultSetMetaData rsmd, int sub, ResultSet rs) throws SQLException {
        Object val;
        String name = rsmd.getColumnLabel(sub);
        String realName = rsmd.getColumnName(sub);
        int fieldType = rsmd.getColumnType(sub);
        if (rs == null) {
            return new DbField(name, realName, fieldType, null, null, false, false);
        }
        boolean readonly = this.isReadonly(rsmd, sub);
        switch (fieldType) {
            case -16: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                val = rs.getObject(sub);
                break;
            }
            case -15: 
            case 1: {
                Object obj = rs.getObject(sub);
                val = obj == null ? null : obj.toString().trim();
                break;
            }
            case 2005: 
            case 2011: {
                val = DbEngineSQLite.clobToString(rs.getClob(sub));
                break;
            }
            case 0: {
                val = null;
                break;
            }
            case 2004: {
                val = rs.getString(sub);
                break;
            }
            default: {
                throw new JDiyUnSupportException(Locale.DBG.getString("err.FieldDb.unSupport"), String.valueOf(rsmd.getColumnType(sub)), rsmd.getTableName(sub), name);
            }
        }
        return new DbField(name, realName, fieldType, val, val, false, readonly);
    }

    private static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader inStreamDoc = clob.getCharacterStream();
            char[] tempDoc = new char[(int)clob.length()];
            inStreamDoc.read(tempDoc);
            inStreamDoc.close();
            return new String(tempDoc);
        }
        catch (Exception e) {
            throw new JDiyUnSupportException(e.getMessage());
        }
    }
}

