/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.field;

import java.math.BigDecimal;
import java.sql.Types;
import java.util.Date;
import net.jdiy.core.convert.Converter;
import net.jdiy.core.ex.JDiyConvertException;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.field.Field;
import net.jdiy.core.res.Locale;

public class DbField
extends Field {
    Object initValue;
    boolean isChanged = false;
    boolean readonly = false;
    Integer type;
    private String realName;

    public DbField(String name, String realName, Integer fieldType, Object value, Object initValue, boolean isChanged, boolean readonly) {
        this.name = name;
        this.realName = realName;
        this.type = fieldType;
        this.value = value;
        this.initValue = initValue;
        this.isChanged = isChanged;
        this.readonly = readonly;
    }

    public static String typeOf(Integer type) {
        if (type == null) {
            return null;
        }
        try {
            for (java.lang.reflect.Field f : Types.class.getFields()) {
                if (!f.get(Types.class).equals(type)) continue;
                return f.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getRealName() {
        return this.realName;
    }

    public Integer getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void toPersist() {
        this.isChanged = false;
        this.initValue = this.value;
    }

    public Date getDate() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToDate();
    }

    public Double getDouble() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToDouble();
    }

    public Float getFloat() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToFloat();
    }

    public Integer getInt() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToInt();
    }

    public Byte getByte() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToByte();
    }

    public Long getLong() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToLong();
    }

    public String getString() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToString();
    }

    public Short getShort() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToShort();
    }

    public boolean getBoolean() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToBoolean();
    }

    public BigDecimal getDecimal() throws JDiyConvertException {
        return Converter.newInstance(this.getValue()).convertToDecimal();
    }

    public String getJson() {
        return Converter.newInstance(this.getValue()).convertToJsonString();
    }

    public Object getObject() {
        return this.value;
    }

    public Object getInitObject() {
        return this.initValue;
    }

    public void setObject(Object object) throws JDiyFieldException {
        if (this.readonly) {
            throw new JDiyFieldException(Locale.DBG.getString("err.FieldDb.unwriteable"), this.name);
        }
        this.value = object;
        this.isChanged = object == null ? this.initValue != null : !object.equals(this.initValue);
    }

    private Object getValue() {
        return this.value;
    }
}

