/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.field;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jdiy.core.Rs;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.field.Field;
import net.jdiy.core.field.FileFilter;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Fn;
import net.jdiy.util.Fs;
import net.jdiy.util.Txt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileField
extends Field {
    private String id;
    private String dataPath;
    private File oldFile = null;
    private File newFile = null;
    private List<File> newFiles = null;
    private File dir = null;
    private boolean clean = false;
    static final Logger log = LoggerFactory.getLogger(FileField.class);
    private static String[] denyFileNames = new String[]{"aux", "con", "prn", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"};

    public FileField(String lowerName) {
        Txt t = new Txt(lowerName);
        if (t.test("^[a-zA-Z-_]+[a-zA-Z0-9-_]*$") && !Fn.contains(denyFileNames, lowerName)) {
            this.name = lowerName;
            return;
        }
        throw new JDiyFieldException(Locale.DBG.getString("err.Rs.wrongFileField"));
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public FileField addFile(File f) {
        if (this.newFiles == null) {
            this.newFiles = new ArrayList<File>();
        }
        this.newFiles.add(f);
        return this;
    }

    public FileField setNewFile(File file) {
        this.clean = true;
        this.newFile = file;
        this.newFiles = null;
        return this;
    }

    public String getF() {
        File[] ls;
        if (this.oldFile != null && this.oldFile.exists()) {
            return String.format("JDiy_data/entity/%s/%s/%s", this.id.substring(this.id.length() - 1), this.id, this.oldFile.getName());
        }
        if (this.dir != null && (ls = this.dir.listFiles(new FileFilter())) != null) {
            for (File f : ls) {
                if (f == null || !f.exists() || !f.isFile()) continue;
                return String.format("JDiy_data/entity/%s/%s/%s/%s", this.id.substring(this.id.length() - 1), this.id, this.name, f.getName());
            }
        }
        return null;
    }

    public String[] getFs() {
        String idPath = String.format("JDiy_data/entity/%s/%s/", this.id.substring(this.id.length() - 1), this.id);
        ArrayList<String> fs = new ArrayList<String>();
        if (this.oldFile != null && this.oldFile.exists()) {
            fs.add(idPath + this.oldFile.getName());
        }
        if (this.dir != null && this.dir.exists()) {
            for (File pf : this.dir.listFiles(new FileFilter())) {
                fs.add(idPath + this.name + "/" + pf.getName());
            }
        }
        return fs.toArray(new String[fs.size()]);
    }

    public File getFile() {
        File[] ls;
        if (this.newFile != null && this.newFile.exists()) {
            return this.newFile;
        }
        if (this.oldFile != null && this.oldFile.exists()) {
            return this.oldFile;
        }
        if (this.dir != null && (ls = this.dir.listFiles(new FileFilter())) != null) {
            for (File f : ls) {
                if (f == null || !f.exists() || !f.isFile()) continue;
                return f;
            }
        }
        return null;
    }

    public File[] getFiles() {
        ArrayList<File> fs = new ArrayList<File>();
        if (this.newFile != null && this.newFile.exists()) {
            fs.add(this.newFile);
        }
        if (this.newFiles != null) {
            fs.addAll(this.newFiles);
        }
        if (!this.clean && this.dir != null && this.dir.exists()) {
            Collections.addAll(fs, this.dir.listFiles(new FileFilter()));
        }
        return fs.toArray(new File[fs.size()]);
    }

    public void toPersist() {
        String path = this.dataPath + File.separator + "entity" + File.separator + this.id.substring(this.id.length() - 1) + File.separator + this.id;
        if (this.clean) {
            File fieldDir;
            if (this.oldFile != null && this.oldFile.exists()) {
                log.info(Locale.DBG.getString("log.DaoImpl.deleteFile"), (Object)this.oldFile.getPath());
                this.oldFile.delete();
            }
            if ((fieldDir = new File(path + File.separator + this.getName())).exists()) {
                log.info(Locale.DBG.getString("log.DaoImpl.deleteFile"), (Object)fieldDir.getPath());
                Fs.delAll(fieldDir);
            }
        }
        String fdPath = path + File.separator + this.getName() + File.separator;
        new File(fdPath).mkdirs();
        if (this.newFile != null) {
            FileField.saveFile(fdPath, this.newFile);
        }
        if (this.newFiles != null) {
            for (File file : this.newFiles) {
                FileField.saveFile(fdPath, file);
            }
        }
        Fs.delEmpty(fdPath);
    }

    public static Map<String, FileField> fileLoad(Rs rs, String dataPath) {
        String id;
        String[] PK;
        HashMap<String, FileField> map = new HashMap<String, FileField>();
        if (dataPath == null || (PK = rs.getPK()) == null || "".equals(id = rs.get(PK[0]))) {
            return map;
        }
        if (PK.length > 1) {
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.jointPK"));
        }
        String path = dataPath + File.separator + "entity" + File.separator + id.substring(id.length() - 1) + File.separator + id;
        File[] fs = new File(path).listFiles(new FileFilter());
        if (fs != null && fs.length > 0) {
            for (File f : fs) {
                if (f.isFile()) {
                    String fnp = f.getName();
                    int dot = fnp.indexOf(".");
                    if (dot == -1) continue;
                    String prefix = fnp.substring(0, dot).toLowerCase();
                    FileField ffd = (FileField)map.get(prefix);
                    if (ffd == null) {
                        ffd = new FileField(prefix);
                    }
                    ffd.oldFile = f;
                    ffd.id = id;
                    ffd.dataPath = dataPath;
                    map.put(prefix, ffd);
                    continue;
                }
                FileField ffd = (FileField)map.get(f.getName().toLowerCase());
                if (ffd == null) {
                    ffd = new FileField(f.getName().toLowerCase());
                }
                ffd.dir = f;
                ffd.id = id;
                ffd.dataPath = dataPath;
                map.put(f.getName(), ffd);
            }
        }
        return map;
    }

    private static void saveFile(String fdPath, File file) {
        if (!file.exists()) {
            throw new JDiyFieldException(Locale.DBG.getString("err.fileNotExists"), file.getPath());
        }
        File newf = new File(fdPath + file.getName());
        if (!newf.exists()) {
            log.info(Locale.DBG.getString("log.DaoImpl.savedFile"), (Object)newf.getPath());
            Fs.copyAs(file, newf, true);
        } else {
            String ext;
            String fn;
            int j = file.getName().indexOf(".");
            if (j == -1) {
                fn = file.getName();
                ext = ".zlt";
            } else {
                fn = file.getName().substring(0, j);
                ext = file.getName().substring(j);
            }
            int sub = 0;
            while ((newf = new File(fdPath + fn + "(" + ++sub + ")" + ext)).exists()) {
            }
            log.info(Locale.DBG.getString("log.DaoImpl.savedFile"), (Object)newf.getPath());
            Fs.copyAs(file, newf, true);
        }
        if (file.getParent().replaceAll("\\\\", "/").endsWith("JDiy_data/temp")) {
            Fs.delAll(file);
        }
    }
}

