/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.core.field;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jdiy.core.Rs;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.ex.JDiyIOException;
import net.jdiy.core.field.Field;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Fs;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultCDATA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlField
extends Field {
    private String value;
    static final Logger log = LoggerFactory.getLogger(XmlField.class);

    public XmlField(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static Map<String, XmlField> xmlLoad(Rs rs, String dataPath) {
        String id;
        String[] PK;
        HashMap<String, XmlField> map = new HashMap<String, XmlField>();
        if (dataPath == null || (PK = rs.getPK()) == null || "".equals(id = rs.get(PK[0]))) {
            return map;
        }
        if (PK.length > 1) {
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.jointPK"));
        }
        String path = dataPath + File.separator + "entity" + File.separator + id.substring(id.length() - 1) + File.separator + id;
        try {
            File f = new File(path + File.separator + "JDiy.xml");
            if (f.exists()) {
                DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = df.newDocumentBuilder();
                FileInputStream is = new FileInputStream(f);
                org.w3c.dom.Document doc = builder.parse(is);
                NodeList ls = doc.getElementsByTagName("jdiy-xml").item(0).getChildNodes();
                for (int i = 0; i < ls.getLength(); ++i) {
                    Node nd = ls.item(i);
                    if (nd.getNodeType() != 1) continue;
                    String nm = nd.getNodeName();
                    String nml = nm.toLowerCase();
                    map.put(nml, new XmlField(nm, nd.getTextContent()));
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.xmlRead"), e.toString());
        }
    }

    public static void toPersist(Rs d, String dataPath, Map<String, XmlField> map) {
        String id;
        String[] PK = d.getPK();
        if (PK == null || "".equals(id = d.get(PK[0]))) {
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.nullPK"));
        }
        if (PK.length > 1) {
            throw new JDiyFieldException(Locale.DBG.getString("err.Rs.jointPK"));
        }
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("jdiy-xml");
        boolean noXmlData = true;
        for (String n : map.keySet()) {
            XmlField fx = map.get(n);
            String xValue = fx.toString();
            if (null == xValue || "".equals(xValue)) continue;
            Element conTblOpr = root.addElement(fx.getName());
            DefaultCDATA conTblOprCdata = new DefaultCDATA(xValue.replaceAll("&amp;lt;", "&lt;").replaceAll("&amp;gt;", "&gt;"));
            conTblOpr.add((CDATA)conTblOprCdata);
            noXmlData = false;
        }
        String idPath = dataPath + File.separator + "entity" + File.separator + id.substring(id.length() - 1) + File.separator + id;
        String path = idPath + File.separator + "JDiy.xml";
        if (noXmlData) {
            Fs.delAll(path);
        } else {
            new File(idPath).mkdirs();
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("utf-8");
            try {
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(path), format);
                writer.write(doc);
                writer.close();
                log.info(Locale.DBG.getString("log.DaoImpl.savedXml"), (Object)path);
            }
            catch (IOException ioe) {
                throw new JDiyIOException("save XML Data error: " + ioe.getMessage(), ioe.getCause());
            }
        }
    }
}

