/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.upload;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpSession;

class CorrectInputStream
extends ServletInputStream {
    private ServletInputStream in;
    private int totalExpected;
    private int totalRead = 0;
    HttpSession session;

    public CorrectInputStream(ServletInputStream in, int totalExpected, HttpSession session) {
        this.in = in;
        this.totalExpected = totalExpected;
        this.session = session;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int left = this.totalExpected - this.totalRead;
        if (left <= 0) {
            return -1;
        }
        int result = this.in.readLine(b, off, Math.min(left, len));
        if (result > 0) {
            this.totalRead += result;
        }
        this.setState();
        return result;
    }

    public int read() throws IOException {
        if (this.totalRead >= this.totalExpected) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            ++this.totalRead;
        }
        this.setState();
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int left = this.totalExpected - this.totalRead;
        if (left <= 0) {
            return -1;
        }
        int result = this.in.read(b, off, Math.min(left, len));
        if (result > 0) {
            this.totalRead += result;
        }
        this.setState();
        return result;
    }

    private void setState() {
        this.session.setAttribute("JD_uploadSize", (Object)String.valueOf(this.totalRead));
    }
}

