/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.jdiy.upload.Part;
import net.jdiy.upload.PartFile;
import net.jdiy.upload.PartParam;
import net.jdiy.upload.RenamePolicy;
import net.jdiy.upload.RequestParser;

public class JDiyRequest
extends HttpServletRequestWrapper {
    protected Hashtable<String, Vector<String>> parameters = new Hashtable();
    protected Hashtable<String, UploadedFile> files = new Hashtable();
    boolean isMultipart;

    public JDiyRequest(HttpServletRequest request, String encoding) throws IOException {
        super(request);
        int read;
        ServletInputStream sis = request.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        byte[] buf = new byte[128];
        while ((read = sis.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        baos.close();
        String postData = new String(baos.toByteArray());
        if (request.getQueryString() != null) {
            for (Map.Entry<String, Vector<String>> ve : JDiyRequest.parseQueryString(request.getQueryString(), encoding).entrySet()) {
                this.parameters.put(ve.getKey(), ve.getValue());
            }
        }
        for (Map.Entry<String, Vector<String>> ve : JDiyRequest.parseQueryString(postData, encoding).entrySet()) {
            if (this.parameters.containsKey(ve.getKey())) {
                this.parameters.get(ve.getKey()).addAll((Collection<String>)ve.getValue());
                continue;
            }
            this.parameters.put(ve.getKey(), ve.getValue());
        }
        this.isMultipart = false;
    }

    public JDiyRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, boolean rename) throws IOException {
        super(request);
        Part part;
        RenamePolicy policy = new RenamePolicy(rename);
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        RequestParser parser = new RequestParser(request, maxPostSize, encoding);
        if (request.getQueryString() != null) {
            for (Map.Entry<String, Vector<String>> ve : JDiyRequest.parseQueryString(request.getQueryString(), encoding).entrySet()) {
                this.parameters.put(ve.getKey(), ve.getValue());
            }
        }
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (part.isParam()) {
                PartParam partParam = (PartParam)part;
                String value = partParam.getStringValue();
                Vector<String> existingValues = this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new Vector();
                    this.parameters.put(name, existingValues);
                }
                existingValues.addElement(value);
                continue;
            }
            if (!part.isFile()) continue;
            PartFile partFile = (PartFile)part;
            String fileName = partFile.getFileName();
            if (fileName != null) {
                partFile.setRenamePolicy(policy);
                partFile.writeTo(dir);
                this.files.put(name, new UploadedFile(dir.toString(), partFile.getFileName(), fileName, partFile.getContentType()));
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null, null));
        }
        this.isMultipart = true;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public Enumeration<String> getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String name) {
        try {
            Vector<String> values = this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            return values.elementAt(values.size() - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector<String> values = this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalFileName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getOriginalFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Hashtable<String, Vector<String>> parseQueryString(String s, String encoding) {
        String pair;
        int pos;
        Hashtable<String, Vector<String>> ht = new Hashtable<String, Vector<String>>();
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens() && (pos = (pair = st.nextToken()).indexOf(61)) != -1) {
            String key = JDiyRequest.parseName(pair.substring(0, pos), sb);
            String val = JDiyRequest.parseName(pair.substring(pos + 1, pair.length()), sb);
            try {
                val = new String(val.getBytes("iso-8859-1"), encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ht.containsKey(key)) {
                ht.get(key).add(val);
                continue;
            }
            Vector<String> v = new Vector<String>();
            v.add(val);
            ht.put(key, v);
        }
        return ht;
    }

    private static String parseName(String s, StringBuilder sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static class UploadedFile {
        private String dir;
        private String filename;
        private String original;
        private String type;

        UploadedFile(String dir, String filename, String original, String type) {
            this.dir = dir;
            this.filename = filename;
            this.original = original;
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }

        public String getOriginalFileName() {
            return this.original;
        }

        public File getFile() {
            if (this.dir == null || this.filename == null) {
                return null;
            }
            return new File(this.dir + File.separator + this.filename);
        }
    }
}

