/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import net.jdiy.upload.MacOutputStream;
import net.jdiy.upload.Part;
import net.jdiy.upload.PartInputStream;
import net.jdiy.upload.RenamePolicy;

class PartFile
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;
    private RenamePolicy policy;

    PartFile(String name, ServletInputStream in, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(in, boundary);
    }

    public void setRenamePolicy(RenamePolicy policy) {
        this.policy = policy;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        OutputStream fileOut = null;
        try {
            if (this.fileName != null) {
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                if (this.policy != null) {
                    file = this.policy.rename(file);
                    this.fileName = file.getName();
                }
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }

    long write(OutputStream out) throws IOException {
        int read;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

