/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.upload;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

class RenamePolicy {
    protected String body;
    protected String ext;
    boolean rename;

    public RenamePolicy(boolean rename) {
        this.rename = rename;
    }

    public File rename(File f) {
        if (this.rename) {
            String newName;
            this.initBodyAndExt(f);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            do {
                newName = sdf.format(new Date()) + ((int)(Math.random() * 899.0) + 100) + this.ext;
            } while (!this.createNewFile(f = new File(f.getParent(), newName)));
            return f;
        }
        if (this.createNewFile(f)) {
            return f;
        }
        this.initBodyAndExt(f);
        int count = 0;
        while (!this.createNewFile(f) && count < 9999) {
            String newName = this.body + ++count + this.ext;
            f = new File(f.getParent(), newName);
        }
        return f;
    }

    protected void initBodyAndExt(File f) {
        String name = f.getName();
        int dot = name.lastIndexOf(".");
        if (dot != -1) {
            this.body = name.substring(0, dot);
            this.ext = name.substring(dot);
        } else {
            this.body = name;
            this.ext = "";
        }
    }

    protected boolean createNewFile(File f) {
        try {
            return f.createNewFile();
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

