/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import java.io.File;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class Eml {
    private MimeMessage message;
    private Multipart mp = new MimeMultipart();
    private Session ssn;
    private String server;
    private String uid;
    private String pwd;

    public Eml(String server, String eml, String uid, String pwd) throws MessagingException {
        this.server = server;
        this.uid = uid;
        this.pwd = pwd;
        Properties props = new Properties();
        props.put("mail.smtp.host", server);
        props.put("mail.smtp.auth", "true");
        props.put("mail.transport.protocol", "smtp");
        CheckSendMail auth = new CheckSendMail(uid, pwd);
        this.ssn = Session.getInstance((Properties)props, (Authenticator)auth);
        this.message = new MimeMessage(this.ssn);
        InternetAddress fromAddress = new InternetAddress(eml);
        this.message.setFrom((Address)fromAddress);
    }

    public Eml setSubject(String subject) throws MessagingException {
        this.message.setSubject(subject);
        return this;
    }

    public Eml setBody(String html) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setContent((Object)html, "text/html; charset=utf-8");
        this.mp.addBodyPart((BodyPart)mbp);
        return this;
    }

    public Eml addTo(String to) throws MessagingException {
        InternetAddress toAddress = new InternetAddress(to);
        this.message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        return this;
    }

    public Eml addCc(String cc) throws MessagingException {
        InternetAddress toAddress = new InternetAddress(cc);
        this.message.addRecipient(Message.RecipientType.CC, (Address)toAddress);
        return this;
    }

    public Eml addBcc(String bcc) throws MessagingException {
        InternetAddress toAddress = new InternetAddress(bcc);
        this.message.addRecipient(Message.RecipientType.BCC, (Address)toAddress);
        return this;
    }

    public void addFile(String filePath) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(filePath);
        mbp.setDataHandler(new DataHandler((DataSource)fds));
        mbp.setFileName(fds.getName());
        this.mp.addBodyPart((BodyPart)mbp);
    }

    public void addFile(File file) throws MessagingException {
        this.addFile(file.getAbsolutePath());
    }

    public void send() throws MessagingException {
        this.message.setContent(this.mp);
        Transport transport = this.ssn.getTransport("smtp");
        transport.connect(this.server, this.uid, this.pwd);
        transport.sendMessage((Message)this.message, this.message.getAllRecipients());
        transport.close();
    }

    class CheckSendMail
    extends Authenticator {
        String username = null;
        String password = null;

        public CheckSendMail(String user, String pass) {
            this.username = user;
            this.password = pass;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

