/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.jdiy.core.ex.JDiyIOException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Fs {
    private static final Logger log = LoggerFactory.getLogger(Fs.class);

    private Fs() {
    }

    public static boolean copyAs(File fromFile, File toFile, boolean overwrite) {
        if (!fromFile.exists()) {
            log.warn(Locale.DBG.getString("warn.Fs.notExistsForCopy"), (Object)fromFile.getPath());
            return false;
        }
        if (fromFile.equals(toFile)) {
            log.warn(Locale.DBG.getString("warn.Fs.sameFileForCopy"), (Object)fromFile.getPath());
            return false;
        }
        if (fromFile.isFile()) {
            return Fs.cpFile(fromFile, toFile, overwrite);
        }
        return Fs.cpDir(fromFile, toFile, overwrite);
    }

    public static boolean copyAs(String fromFile, String toFile, boolean overwrite) {
        return Fs.copyAs(new File(fromFile), new File(toFile), overwrite);
    }

    public static boolean copyTo(File fromFile, File toDir, boolean overwrite) {
        if (toDir.isFile()) {
            log.error(Locale.DBG.getString("warn.Fs.notDirForCopy"), (Object)toDir.getPath());
            return false;
        }
        return Fs.copyAs(fromFile, new File(toDir.getPath() + File.separator + fromFile.getName()), overwrite);
    }

    public static boolean copyTo(String fromFile, String toDir, boolean overwrite) {
        return Fs.copyTo(new File(fromFile), new File(toDir), overwrite);
    }

    public static void delAll(File file) {
        File[] fs;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (fs = file.listFiles()) != null) {
            for (File f : fs) {
                Fs.delAll(f);
            }
        }
        file.delete();
    }

    public static void delAll(String file) {
        Fs.delAll(new File(file));
    }

    public static synchronized void delEmpty(File dir) {
        if (dir.isFile()) {
            return;
        }
        String[] s = dir.list();
        if (s == null || s.length < 1) {
            dir.delete();
        }
    }

    public static void delEmpty(String path) {
        Fs.delEmpty(new File(path));
    }

    public static void empty(File dir) {
        File[] fs;
        if (dir.isDirectory() && (fs = dir.listFiles()) != null) {
            for (File f : fs) {
                Fs.delAll(f);
            }
        }
    }

    public static void empty(String dir) {
        Fs.delEmpty(new File(dir));
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            properties.load(Fs.getResource(resource).openStream());
        }
        catch (IOException e) {
            throw new JDiyIOException(Locale.DBG.getString("err.Fs.propertiesLoadErr"), resource, e.getMessage());
        }
        return properties;
    }

    public static URL getResource(String relativePath) throws MalformedURLException {
        if (relativePath == null) {
            relativePath = "./";
        } else if (relativePath.startsWith("/")) {
            relativePath = "." + relativePath;
        } else if (!relativePath.startsWith("./") && !relativePath.startsWith("../")) {
            relativePath = "./" + relativePath;
        }
        String classAbsPath = Fs.class.getClassLoader().getResource("").toString();
        String parentStr = relativePath.substring(0, relativePath.lastIndexOf("../") + 3);
        relativePath = relativePath.substring(relativePath.lastIndexOf("../") + 3);
        int containSum = Txt.containSum(parentStr, "../");
        for (int i = 0; i < containSum; ++i) {
            classAbsPath = classAbsPath.substring(0, classAbsPath.lastIndexOf("/", classAbsPath.length() - 2) + 1);
        }
        return new URL(classAbsPath + relativePath);
    }

    public static boolean moveAs(File fromFile, File toFile, boolean overwrite) {
        if (Fs.copyAs(fromFile, toFile, overwrite)) {
            Fs.delAll(fromFile);
            return true;
        }
        return false;
    }

    public static boolean moveAs(String fromFile, String toFile, boolean overwrite) {
        if (Fs.copyAs(fromFile, toFile, overwrite)) {
            Fs.delAll(fromFile);
            return true;
        }
        return false;
    }

    public static boolean moveTo(File fromFile, File toDir, boolean overwrite) {
        if (Fs.copyTo(fromFile, toDir, overwrite)) {
            Fs.delAll(fromFile);
            return true;
        }
        return false;
    }

    public static boolean moveTo(String fromFile, String toDir, boolean overwrite) {
        if (Fs.copyTo(fromFile, toDir, overwrite)) {
            Fs.delAll(fromFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader reader = null;
        try {
            String text;
            if (encoding == null || "".equals(encoding)) {
                encoding = "utf-8";
            }
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            reader = new BufferedReader(read);
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignore) {}
        }
        return contents.toString();
    }

    public static String readFile(File file) throws IOException {
        return Fs.readFile(file, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String str, String encoding) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            osw.write(str);
            osw.flush();
        }
        finally {
            try {
                if (null != osw) {
                    osw.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeFile(File file, String str) throws IOException {
        Fs.writeFile(file, str, "utf-8");
    }

    public static long size(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] fs = file.listFiles();
        long sizes = 0L;
        if (fs != null) {
            for (File f1 : fs) {
                sizes += Fs.size(f1);
            }
        }
        return sizes;
    }

    public static long size(String path) {
        return Fs.size(new File(path));
    }

    public static String sizeStr(long size) {
        double size0;
        String s = "Byte";
        if (size < 0x100000L && size > 1024L) {
            size0 = (double)size / 1024.0;
            s = "KB";
        } else if (size < 1048576000L && size > 0x100000L) {
            size0 = (double)size / 1048576.0;
            s = "MB";
        } else if (size < 0x10000000000L && size > 0x40000000L) {
            size0 = (double)size / 1.073741824E9;
            s = "GB";
        } else {
            size0 = size;
        }
        size0 = (double)Math.round(size0 * 100.0) / 100.0;
        String ss = String.valueOf(size0);
        if (ss.lastIndexOf(".") == ss.length() - 2) {
            ss = ss + "0";
        }
        return ss + " " + s;
    }

    public static String sizeStr(File file) {
        return Fs.sizeStr(Fs.size(file));
    }

    public static String sizeStr(String path) {
        return Fs.sizeStr(Fs.size(path));
    }

    private static boolean cpFile(File fromFile, File toFile, boolean overWrite) {
        if (!overWrite && toFile.exists()) {
            log.warn(Locale.DBG.getString("warn.Fs.targetFileExists"), (Object)toFile.getPath());
            return false;
        }
        toFile.getParentFile().mkdirs();
        try {
            int byteread;
            FileInputStream inStream = new FileInputStream(fromFile.getPath());
            FileOutputStream fs = new FileOutputStream(toFile.getPath());
            byte[] buffer = new byte[1444];
            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            ((InputStream)inStream).close();
            fs.close();
            return true;
        }
        catch (Exception ioe) {
            throw new JDiyIOException(Locale.DBG.getString("err.Fs.cpErr"), ioe.getMessage());
        }
    }

    private static boolean cpDir(File fromFile, File toFile, boolean overWrite) {
        if (!overWrite && toFile.exists()) {
            log.warn(Locale.DBG.getString("warn.Fs.targetFileExists"), (Object)toFile.getPath());
            return false;
        }
        toFile.mkdirs();
        File[] files = fromFile.listFiles();
        boolean isOk = true;
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (Fs.cpFile(file, new File(toFile.getPath() + File.separator + file.getName()), true)) continue;
                    isOk = false;
                    continue;
                }
                if (Fs.cpDir(file, new File(toFile.getPath() + File.separator + file.getName()), true)) continue;
                isOk = false;
            }
        }
        return isOk;
    }
}

