/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.jdiy.core.ex.JDiyIOException;
import net.jdiy.core.res.Locale;

public final class Pic {
    private int width = 0;
    private int height = 0;
    private File file;
    private BufferedImage image;
    private int opacityType = 1;

    private Pic() {
    }

    public Pic(File file) {
        BufferedImage src;
        this.file = file;
        if (!this.file.exists()) {
            throw new JDiyIOException(Locale.DBG.getString("err.fileNotExists"), file.getPath());
        }
        if (this.file.isDirectory()) {
            throw new JDiyIOException(Locale.DBG.getString("err.Pic.isDir"));
        }
        String fn = file.getName().toLowerCase();
        this.opacityType = fn.endsWith(".png") || fn.endsWith("gif") ? 2 : 1;
        try {
            src = ImageIO.read(this.file);
        }
        catch (IllegalArgumentException e) {
            throw new JDiyIOException(Locale.DBG.getString("err.Pic.errICC"));
        }
        catch (IOException e) {
            throw new JDiyIOException(e.fillInStackTrace());
        }
        this.width = ((Image)src).getWidth(null);
        this.height = ((Image)src).getHeight(null);
        this.image = new BufferedImage(this.width, this.height, this.opacityType);
        Graphics2D g = this.image.createGraphics();
        g.drawImage(src, 0, 0, this.width, this.height, null);
        g.dispose();
    }

    public Pic add(File file, int position) {
        int HH;
        int WW;
        BufferedImage src;
        try {
            src = ImageIO.read(file);
        }
        catch (IllegalArgumentException e) {
            throw new JDiyIOException(Locale.DBG.getString("err.Pic.errICC"));
        }
        catch (IOException e) {
            throw new JDiyIOException(e.fillInStackTrace());
        }
        int ww = ((Image)src).getWidth(null);
        int hh = ((Image)src).getHeight(null);
        switch (position) {
            case 1: {
                WW = 0;
                HH = 0;
                break;
            }
            case 2: {
                WW = (this.width - ww) / 2;
                HH = 0;
                break;
            }
            case 3: {
                WW = this.width - ww;
                HH = 0;
                break;
            }
            case 4: {
                WW = 0;
                HH = (this.height - hh) / 2;
                break;
            }
            case 5: {
                WW = (this.width - ww) / 2;
                HH = (this.height - hh) / 2;
                break;
            }
            case 6: {
                WW = this.width - ww;
                HH = (this.height - hh) / 2;
                break;
            }
            case 7: {
                WW = 0;
                HH = this.height - hh;
                break;
            }
            case 8: {
                WW = (this.width - ww) / 2;
                HH = this.height - hh;
                break;
            }
            default: {
                WW = this.width - ww;
                HH = this.height - hh;
            }
        }
        Graphics2D g = this.image.createGraphics();
        g.drawImage(src, WW, HH, ww, hh, null);
        g.dispose();
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Pic resizeBy(int w, int h) {
        if (w == 0 && h == 0 || w == this.width && h == this.height) {
            return this;
        }
        int w1 = w;
        int h1 = h;
        if (w1 > h1) {
            h1 = this.height * w1 / this.width;
        } else {
            w1 = this.width * h1 / this.height;
        }
        if (w != 0 && h != 0) {
            if (w1 > w) {
                h1 = w * h1 / w1;
                w1 = w;
            } else if (h1 > h) {
                w1 = h * w1 / h1;
                h1 = h;
            }
        }
        return this.resizeTo(w1, h1);
    }

    public Pic resizeBy(int w, int h, Color c) {
        if (w == this.width && h == this.height) {
            return this;
        }
        this.resizeBy(w, h);
        int L = (w - this.width) / 2;
        int T = (h - this.height) / 2;
        BufferedImage image1 = new BufferedImage(w, h, this.opacityType);
        Graphics2D g = image1.createGraphics();
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        try {
            g.drawImage(this.image, L, T, this.width, this.height, null);
            this.image = image1;
            this.width = w;
            this.height = h;
        }
        catch (IllegalArgumentException e) {
            throw new JDiyIOException(Locale.DBG.getString("err.Pic.errICC"));
        }
        return this;
    }

    public Pic resizeTo(int w, int h) {
        if (w == this.width && h == this.height) {
            return this;
        }
        if (w == 0 || h == 0) {
            return this.resizeBy(w, h);
        }
        BufferedImage image1 = new BufferedImage(w, h, this.opacityType);
        Graphics2D g = image1.createGraphics();
        try {
            g.drawImage(this.image, 0, 0, w, h, null);
            this.image = image1;
        }
        catch (IllegalArgumentException e) {
            throw new JDiyIOException(Locale.DBG.getString("err.Pic.errICC"));
        }
        this.width = w;
        this.height = h;
        return this;
    }

    public void saveAs(File file) {
        String path = file.getAbsolutePath();
        String ext = path.substring(path.lastIndexOf(".") + 1).toUpperCase();
        if (!ext.equals("PNG") && !ext.equals("GIF")) {
            ext = "JPEG";
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            ImageIO.write((RenderedImage)this.image, ext, out);
            out.close();
        }
        catch (IOException e) {
            throw new JDiyIOException(e.fillInStackTrace());
        }
    }

    public void save() {
        this.saveAs(this.file);
    }
}

