/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import com.sun.crypto.provider.SunJCE;
import java.security.MessageDigest;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jdiy.core.ex.JDiySecurityException;

public class Sec {
    public static String AESKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            return Sec.byteArr2HexStr(raw);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String AESDecrypt(String encrypted, String rawKey) {
        byte[] tmp = Sec.hexStr2ByteArr(encrypted);
        byte[] key = Sec.hexStr2ByteArr(rawKey);
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(tmp);
            return new String(decrypted);
        }
        catch (Exception e) {
            throw new JDiySecurityException("AES Decrypt Error!");
        }
    }

    public static String AESEncrypt(String message, String rawKey) {
        byte[] key = Sec.hexStr2ByteArr(rawKey);
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(message.getBytes());
            return Sec.byteArr2HexStr(encrypted);
        }
        catch (Exception e) {
            throw new JDiySecurityException("AES Encrypt Error!");
        }
    }

    public static String DESDecrypt(String encrypted, String rawKey) {
        Security.addProvider(new SunJCE());
        byte[] arrBTmp = rawKey.getBytes();
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        try {
            SecretKeySpec key = new SecretKeySpec(arrB, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, key);
            return new String(cipher.doFinal(Sec.hexStr2ByteArr(encrypted)));
        }
        catch (Exception ex) {
            throw new JDiySecurityException("\u83b7\u53d6DES\u89e3\u5bc6\u5b57\u7b26\u4e32\u51fa\u9519\u3002");
        }
    }

    public static String DESEncrypt(String message, String rawKey) {
        Security.addProvider(new SunJCE());
        byte[] arrBTmp = rawKey.getBytes();
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        try {
            SecretKeySpec key = new SecretKeySpec(arrB, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            return Sec.byteArr2HexStr(cipher.doFinal(message.getBytes()));
        }
        catch (Exception ex) {
            throw new JDiySecurityException("\u83b7\u53d6DES\u52a0\u5bc6\u5b57\u7b26\u4e32\u51fa\u9519\u3002");
        }
    }

    public static String MD5Encrypt(String message, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(message.getBytes());
            byte[] b = md.digest();
            StringBuilder buf = new StringBuilder("");
            for (int n : b) {
                int i = n;
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            String str32 = buf.toString().toUpperCase();
            if (length == 32) {
                return str32;
            }
            if (length == 16) {
                return str32.substring(8, 24);
            }
            throw new JDiySecurityException("MD5 Encrypt Error: the 'length' must be use 16 or 32.");
        }
        catch (Exception e) {
            throw new JDiySecurityException("MD5 Encrypt Error!");
        }
    }

    private static String byteArr2HexStr(byte[] buf) {
        StringBuilder strbuf = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static byte[] hexStr2ByteArr(String src) {
        if (src.length() < 1) {
            return null;
        }
        byte[] encrypted = new byte[src.length() / 2];
        for (int i = 0; i < src.length() / 2; ++i) {
            int high = Integer.parseInt(src.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(src.substring(i * 2 + 1, i * 2 + 2), 16);
            encrypted[i] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    private Sec() {
    }
}

