/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Txt {
    private String str;

    public Txt(String str) {
        this.str = str;
    }

    public static int containSum(String source, String dest) {
        return (source.length() - new Txt(source).restr(dest, "").toString().length()) / dest.length();
    }

    public static String cut(String str, int toCount) {
        try {
            StringBuilder reStr = new StringBuilder("");
            char[] tempChar = str.toCharArray();
            for (int i = 0; i < tempChar.length; ++i) {
                byte[] b = String.valueOf(tempChar[i]).getBytes("utf-8");
                if ((toCount -= b.length > 1 ? 2 : 1) <= 0) {
                    if (i == tempChar.length - 1) {
                        reStr.append(tempChar[i]);
                        continue;
                    }
                    reStr.append("\u2026");
                    break;
                }
                reStr.append(tempChar[i]);
            }
            return reStr.toString();
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String inject(String inputString, String ... injects) {
        return Txt.injectBy(inputString, "{}", injects);
    }

    public static String injectBy(String inputString, String injectString, String ... injects) {
        int sub;
        if (inputString == null || injects == null || injects.length == 0) {
            return inputString;
        }
        if (injectString == null || "".equals(injectString)) {
            injectString = "{}";
        }
        StringBuilder sb = new StringBuilder();
        int begin = 0;
        int replaced = 0;
        int len = injectString.length();
        int len1 = injects.length;
        while ((sub = inputString.indexOf(injectString, begin)) != -1 && replaced < len1) {
            sb.append(inputString.substring(begin, sub)).append(injects[replaced++]);
            begin = sub + len;
        }
        sb.append(inputString.substring(begin));
        return sb.toString();
    }

    public static String join(String[] arr, String joinStr) {
        if (null == arr) {
            return null;
        }
        if (null == joinStr) {
            joinStr = ", ";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(joinStr);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String[] split(String str, String sp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int index = 0;
        int offset = 0;
        int len = sp.length();
        while ((index = str.indexOf(sp, index + len)) != -1) {
            arrayList.add(str.substring(offset, index));
            offset = index + len;
        }
        if (offset < str.length()) {
            arrayList.add(str.substring(offset));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String htmlToText(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        String scriptRegEx = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
        String styleRegEx = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
        String htmlRegEx1 = "<[^>]*>";
        String htmlRegEx2 = "<[^>]*";
        try {
            Pattern scriptPattern = Pattern.compile(scriptRegEx, 2);
            Matcher scriptMatcher = scriptPattern.matcher(htmlStr);
            htmlStr = scriptMatcher.replaceAll("");
            Pattern stylePattern = Pattern.compile(styleRegEx, 2);
            Matcher styleMatcher = stylePattern.matcher(htmlStr);
            htmlStr = styleMatcher.replaceAll("");
            Pattern htmlPattern1 = Pattern.compile(htmlRegEx1, 2);
            Matcher htmlMatcher1 = htmlPattern1.matcher(htmlStr);
            htmlStr = htmlMatcher1.replaceAll("");
            Pattern htmlPattern2 = Pattern.compile(htmlRegEx2, 2);
            Matcher htmlMatcher2 = htmlPattern2.matcher(htmlStr);
            textStr = htmlStr = htmlMatcher2.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("->htmlToText(String inputString):" + e.getMessage());
        }
        textStr = textStr.replaceAll("&acute;", "'");
        textStr = textStr.replaceAll("&quot;", "\"");
        textStr = textStr.replaceAll("&lt;", "<");
        textStr = textStr.replaceAll("&gt;", ">");
        textStr = textStr.replaceAll("&nbsp;", " ");
        textStr = textStr.replaceAll("&amp;", "&");
        return textStr;
    }

    public static String encodeHTML(String str) {
        String s = str.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&acute; ").replaceAll("  ", " &nbsp;").replaceAll("\\r\\n", "<br />").replaceAll("\\n", "<br />");
        Txt rep = new Txt(s);
        rep.replace("http://([%#=&\\?\\./a-zA-Z0-9]+)", "<a href=\"http://$1\" target=\"_blank\">http://$1</a>");
        rep.replace("([-_a-z0-9]+?)@([-_\\.a-zA-Z0-9]{5,})", "<a href=\"mailto:$1@$2\" target=\"_blank\">$1@$2</a>");
        return rep.toString();
    }

    public static double parseDouble(String s) {
        return Txt.parseDouble(s, 0.0);
    }

    public static double parseDouble(String s, double defV) {
        try {
            return Double.parseDouble(new Txt(s).replace("^(\\d+)(\\.*)(\\d*)(.|\r|\n)*$", "$1$2$3").toString());
        }
        catch (Exception e) {
            return defV;
        }
    }

    public static int parseInt(String s) {
        return Txt.parseInt(s, 0);
    }

    public static int parseInt(String s, int defV) {
        try {
            return Integer.parseInt(new Txt(s).replace("(\\d+)(.|\r|\n)*$", "$1").toString());
        }
        catch (Exception e) {
            return defV;
        }
    }

    public static long parseLong(String s) {
        return Txt.parseLong(s, 0L);
    }

    public static long parseLong(String s, long defV) {
        try {
            return Long.parseLong(new Txt(s).replace("(\\d+)(.|\r|\n)*$", "$1").toString());
        }
        catch (Exception e) {
            return defV;
        }
    }

    public boolean test(String regStr) {
        Pattern pattern = Pattern.compile(regStr);
        Matcher matcher = pattern.matcher(this.str);
        return matcher.matches();
    }

    public boolean find(String regStr) {
        Pattern pattern = Pattern.compile(regStr);
        Matcher matcher = pattern.matcher(this.str);
        return matcher.find();
    }

    public Txt replace(String regStr, String s1) {
        Pattern pattern = Pattern.compile(regStr);
        Matcher matcher = pattern.matcher(this.str);
        this.str = matcher.replaceAll(s1);
        return this;
    }

    public Txt replaceFirst(String regStr, String s1) {
        Pattern pattern = Pattern.compile(regStr);
        Matcher matcher = pattern.matcher(this.str);
        this.str = matcher.replaceFirst(s1);
        return this;
    }

    public Txt restr(String s1, String s2) {
        int b;
        StringBuilder sb = new StringBuilder();
        int e = 0;
        int len = s1.length();
        while ((b = this.str.indexOf(s1, e)) != -1) {
            sb.append(this.str.substring(e, b));
            sb.append(s2);
            e = b + len;
        }
        if (e < this.str.length()) {
            sb.append(this.str.substring(e));
        }
        this.str = sb.toString();
        return this;
    }

    public String toString() {
        return this.str;
    }
}

