/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.res.Locale;
import net.jdiy.util.Txt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Url {
    private String url;
    private String bookmark = "";
    private String charset;
    private Map<String, String> postData;
    private Map<String, String> headData;
    private boolean connected = false;
    private Map<String, List<String>> responseHeadData;
    private String responseHtml;
    private static final Logger log = LoggerFactory.getLogger(Url.class);

    private Url() {
    }

    public Url(String url) {
        this(url, "utf-8");
    }

    public Url(String url, String charset) {
        if (url == null) {
            this.url = "./";
        } else {
            int at = url.indexOf("#");
            if (at == -1) {
                this.url = url;
            } else {
                this.bookmark = url.substring(at);
                this.url = url.substring(0, at);
            }
            if (charset == null || "".equals(charset = charset.trim())) {
                charset = "utf-8";
            }
            this.charset = charset;
        }
    }

    public File download(File file) throws IOException {
        int len;
        log.info(this.toString() + " > " + file.getAbsolutePath());
        long bTime = System.currentTimeMillis();
        URL urlX = new URL(this.toString());
        BufferedInputStream bis = new BufferedInputStream(urlX.openStream());
        byte[] bytes = new byte[4096];
        FileOutputStream bos = new FileOutputStream(file);
        while ((len = bis.read(bytes)) > 0) {
            bos.write(bytes, 0, len);
        }
        bis.close();
        bos.flush();
        bos.close();
        long time = System.currentTimeMillis() - bTime;
        log.info(time + " ms. OK");
        return file;
    }

    public void outTo(OutputStream out) throws IOException {
        int bytesRead;
        URL url = new URL(this.toString());
        InputStream in = url.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
    }

    public void outTo(Writer out) throws IOException {
        int charsRead;
        URL url = new URL(this.toString());
        URLConnection con = url.openConnection();
        con.connect();
        String encoding = con.getContentEncoding();
        BufferedReader in = encoding == null ? new BufferedReader(new InputStreamReader(url.openStream())) : new BufferedReader(new InputStreamReader(url.openStream(), encoding));
        char[] buf = new char[4096];
        while ((charsRead = in.read(buf)) != -1) {
            out.write(buf, 0, charsRead);
        }
    }

    public Url del(String ... args) {
        for (String names : args) {
            String[] nameA;
            for (String n : nameA = Txt.split(names.replaceAll(" ", ",").replaceAll(";", ","), ",")) {
                int iEnd;
                if (n == null || n.equals("")) continue;
                String s = n + "=";
                if (this.url.contains("?" + s)) {
                    iEnd = this.url.indexOf("&", this.url.indexOf("?" + s));
                    this.url = iEnd == -1 ? this.url.substring(0, this.url.indexOf("?")) : this.url.substring(0, this.url.indexOf("?") + 1) + this.url.substring(iEnd + 1);
                    this.connected = false;
                    continue;
                }
                if (!this.url.contains("&" + s)) continue;
                iEnd = this.url.indexOf("&", this.url.indexOf("&" + s) + s.length() + 1);
                this.url = iEnd == -1 ? this.url.substring(0, this.url.indexOf("&" + s)) : this.url.substring(0, this.url.indexOf("&" + s)) + this.url.substring(iEnd);
                this.connected = false;
            }
        }
        return this;
    }

    public String getHeader(String name) {
        if (name == null) {
            return this.headData.get(null);
        }
        for (String s : this.headData.keySet()) {
            if (!s.toLowerCase().equals(name)) continue;
            return this.headData.get(s);
        }
        return null;
    }

    public synchronized Url setHeader(String name, String value) {
        if (this.headData == null) {
            this.headData = new HashMap<String, String>();
        }
        this.headData.put(name, value);
        this.connected = false;
        return this;
    }

    public String get(String name) {
        String b;
        String s = name + "=";
        if (this.url.contains("?" + s)) {
            b = "?" + s;
        } else if (this.url.contains("&" + s)) {
            b = "&" + s;
        } else {
            return null;
        }
        int iEnd = this.url.indexOf("&", this.url.indexOf(b) + b.length());
        String rtn = iEnd == -1 ? this.url.substring(this.url.indexOf(b) + b.length()) : this.url.substring(this.url.indexOf(b) + b.length(), iEnd) + "";
        try {
            return URLDecoder.decode(rtn, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new JDiyUnSupportException(Locale.DBG.getString("err.Url.unknowEncoding"), this.charset);
        }
    }

    public String getAnchor() {
        return this.bookmark.replaceAll("^#+", "");
    }

    public Url setAnchor(String anchor) {
        this.bookmark = anchor == null || "".equals(anchor.trim()) ? "" : "#" + anchor.trim().replaceAll("^#+", "");
        this.connected = false;
        return this;
    }

    public synchronized Url post(String name, String value) {
        if (this.postData == null) {
            this.postData = new HashMap<String, String>();
        }
        try {
            this.postData.put(name, URLEncoder.encode(value, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new JDiyUnSupportException(Locale.DBG.getString("err.Url.unknowEncoding"), this.charset);
        }
        this.connected = false;
        return this;
    }

    public Url set(String name, String value) {
        int iEnd;
        try {
            value = URLEncoder.encode(value, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new JDiyUnSupportException(Locale.DBG.getString("err.Url.unknowEncoding"), this.charset);
        }
        String s = name + "=";
        String b = null;
        if (this.url.contains("?" + s)) {
            b = "?" + s;
        } else if (this.url.contains("&" + s)) {
            b = "&" + s;
        }
        this.url = b == null ? this.url + (!this.url.contains("?") ? "?" : "&") + s + value : ((iEnd = this.url.indexOf("&", this.url.indexOf(b) + b.length())) == -1 ? this.url.substring(0, this.url.indexOf(b) + b.length()) + value : this.url.substring(0, this.url.indexOf(b) + b.length()) + value + this.url.substring(iEnd));
        this.connected = false;
        return this;
    }

    public Url set(String name, int value) throws JDiyUnSupportException {
        return this.set(name, String.valueOf(value));
    }

    public Url setF(String fileVPath) {
        if (fileVPath.contains("?")) {
            fileVPath = fileVPath.substring(0, fileVPath.indexOf("?"));
        }
        this.url = !this.url.contains("?") ? fileVPath : fileVPath + this.url.substring(this.url.indexOf("?"));
        this.connected = false;
        return this;
    }

    public String getHtml() throws IOException {
        this.net();
        return this.responseHtml;
    }

    public String getResponseHeader(String name) throws IOException {
        this.net();
        List<String> r = this.responseHeadData.get(name);
        return r == null || r.size() < 1 ? null : r.get(0);
    }

    public Map<String, List<String>> getResponseHeaders() throws IOException {
        this.net();
        return this.responseHeadData;
    }

    public Url connect() {
        this.connected = false;
        return this;
    }

    public String getPost() {
        if (this.postData == null) {
            return "";
        }
        String s = this.postData.toString().replaceAll(", ", "&");
        return s.substring(1, s.length() - 1);
    }

    public String toString() {
        return this.url + this.bookmark;
    }

    private synchronized void net() throws IOException {
        String rLine;
        if (this.connected) {
            return;
        }
        URL urlX = new URL(this.toString());
        URLConnection conn = urlX.openConnection();
        conn.setUseCaches(false);
        conn.setDoInput(true);
        long bTime = System.currentTimeMillis();
        if (this.headData != null) {
            for (String k : this.headData.keySet()) {
                conn.addRequestProperty(k, this.headData.get(k));
            }
        }
        if (this.postData != null) {
            log.info("POST " + this.toString() + " " + this.getPost());
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), this.charset);
            out.write(this.getPost());
            out.flush();
            out.close();
        } else {
            log.info("GET " + this.toString());
        }
        InputStream in = null;
        String ce = conn.getHeaderField("Content-Encoding");
        try {
            if ("gzip".equals(ce)) {
                in = new GZIPInputStream(conn.getInputStream());
            } else if ("deflater".equals(ce)) {
                in = new DeflaterInputStream(conn.getInputStream());
            }
        }
        catch (Exception ignore) {
            in = conn.getInputStream();
        }
        if (in == null) {
            in = conn.getInputStream();
        }
        StringBuilder s = new StringBuilder();
        BufferedReader bReader = new BufferedReader(new InputStreamReader(in, this.charset));
        while ((rLine = bReader.readLine()) != null) {
            if (rLine.length() <= 0) continue;
            s.append(rLine);
        }
        in.close();
        this.responseHtml = s.toString();
        this.responseHeadData = conn.getHeaderFields();
        this.connected = true;
        long time = System.currentTimeMillis() - bTime;
        log.info(time + " ms. " + conn.getHeaderField(null));
    }
}

