/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.web.console;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import net.jdiy.core.App;
import net.jdiy.core.Args;
import net.jdiy.core.Rs;
import net.jdiy.core.ex.JDiyFieldException;
import net.jdiy.core.ex.JDiySecurityException;
import net.jdiy.util.Fn;
import net.jdiy.util.Fs;
import net.jdiy.util.Pic;
import net.jdiy.util.Sec;
import net.jdiy.util.Txt;
import net.jdiy.util.Url;
import net.jdiy.web.console.ViewAbstract;
import net.jdiy.web.nativesql.Nativesql;

public final class ViewUpdate
extends ViewAbstract {
    protected static final String[] disabledExt = new String[]{"asa", "asax", "asp", "aspx", "bat", "bash", "bin", "cgi", "class", "cmd", "com", "cdx", "cer", "dll", "do", "ear", "exe", "hta", "htaccess", "idc", "jar", "jsp", "jd", "jsf", "php", "php4", "php5", "py", "perl", "reg", "sh", "war", "zlt"};
    private String tempPath = this.getJDiyDataPath() + File.separator + "temp";

    public ViewUpdate() {
        new File(this.tempPath).mkdirs();
    }

    public void doBatChange() throws SQLException, IOException {
        String[] prm = Txt.split(this.ac.get("__JDiy_Param__"), ",");
        String ids = this.ac.get("ids");
        String tb = this.ac.get("__JDiy_Table__");
        boolean isJDiyTable = "1".equals(this.ac.get("isJDiyTable"));
        if (prm.length == 2) {
            if (isJDiyTable && "tid".equals(prm[0])) {
                Rs d = this.dao.rs(new Args(tb, "id='" + prm[1] + "'", "frame"));
                if (!d.isNull()) {
                    this.dao.exec("UPDATE " + tb + " SET tid='" + prm[1] + "', frame='" + d.get("frame") + prm[1] + ".' WHERE id IN (" + ids + ")");
                }
            } else {
                Rs td = this.dao.rs(new Args(tb, "1=0"));
                this.dao.exec("UPDATE " + tb + " SET " + prm[0] + "='" + prm[1] + "' WHERE " + td.getPK()[0] + " IN (" + ids + ")");
            }
        }
        PrintWriter out = this.response.getWriter();
        out.write("success");
    }

    public void doSort() throws SQLException, IOException {
        String ids = this.ac.get("ids");
        String table = this.ac.get("__JDiy_Table__");
        String[] ida = Txt.split(ids.replaceAll("'", ""), ",");
        for (int i = 0; i < ida.length; ++i) {
            this.dao.exec("UPDATE " + table + " SET sort=" + this.ac.get("sort_" + ida[i]) + " WHERE id='" + ida[i] + "'");
        }
        this.doBack("successUpdate", null, null);
    }

    public void doDelete() throws IOException, SQLException {
        String tb = this.ac.get("__JDiy_Table__");
        String ids = this.ac.get("ids");
        boolean isJDiyTable = "1".equals(this.ac.get("isJDiyTable"));
        boolean ld = this.ac.getInt("ldAllowed") == 1;
        String DATA_PK = this.ac.get("DATA_PK", "id");
        int isc = this.ac.getInt("isc");
        Args args = new Args(tb);
        String[] idsa = Txt.split(ids, ",");
        for (int i = 0; i < idsa.length; ++i) {
            Rs[] delItems;
            StringBuilder filter = new StringBuilder(DATA_PK + "=" + idsa[i]);
            if ("jdiy_mm".equalsIgnoreCase(tb)) {
                filter.append(" OR tid=").append(idsa[i]).append(" OR cid=").append(idsa[i]);
            } else if (isJDiyTable && !"jdiy_vi".equalsIgnoreCase(tb)) {
                if (ld) {
                    filter.append(" OR frame LIKE '%.").append(idsa[i].replaceAll("'", "")).append(".%'");
                } else if (this.dao.ls(new Args(tb, "tid=" + idsa[i])).getItems().length > 0) continue;
            }
            args.setFilter(filter.toString());
            for (Rs rs : delItems = this.dao.ls(args).getItems()) {
                rs.setPK(DATA_PK);
                this.dao.del(rs);
            }
        }
        this.doBack(isc == 0 || ld ? "successDelete" : "successUpdate", null, null);
    }

    private void doBack(String status, String id, String signer) throws IOException {
        PrintWriter out = this.response.getWriter();
        String bUrl = null;
        bUrl = this.ac.get("__JDiy_Jump__");
        if (bUrl == null || bUrl.equals("")) {
            bUrl = (String)App.get().getRequest().getSession().getAttribute("__JDiy_Jump__");
        }
        if (bUrl == null || bUrl.equals("")) {
            out.write("<script type=\"text/ecmascript\">");
            out.write("history.back(1);");
            out.write("</script>");
            return;
        }
        bUrl = new Url(bUrl).set("JD_Status", status).toString();
        if (id != null && signer != null) {
            bUrl = new Url(bUrl).set("JD_backId", id).set("JD_backSigner", signer).toString();
        }
        this.response.sendRedirect(bUrl);
    }

    private void scriptError(String msg) throws IOException {
        PrintWriter out = this.response.getWriter();
        out.write("<script type=\"text/ecmascript\">\r\n");
        out.write("alert('" + msg + "');");
        out.write("try{history.back(1);}catch(e){window.close();}</script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave() throws IOException, SQLException {
        try {
            String px;
            String id;
            String pk;
            String table;
            String referer = this.request.getHeader("referer");
            String url = "http://" + this.request.getServerName();
            if (referer != null && referer.indexOf(url) != 0) {
                this.scriptError("\u5bf9\u4e0d\u8d77\uff0c\u7531\u4e8e\u60a8\u975e\u6cd5\u63d0\u4ea4\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u88ab\u62d2\u7edd!");
                return;
            }
            try {
                table = Sec.AESDecrypt(this.ac.get("__JDiy_Table__"), "4b2c794b4ab11bd3e6ee6297a90759d1");
                pk = Sec.AESDecrypt(this.ac.get("__JDiy_Pk__"), "4b2c794b4ab11bd3e6ee6297a90759d1");
                id = Sec.AESDecrypt(this.ac.get("__JDiy_Id__"), "4b2c794b4ab11bd3e6ee6297a90759d1");
                px = this.ac.get("__JDiy_Px__").equals("") ? null : Sec.AESDecrypt(this.ac.get("__JDiy_Px__"), "4b2c794b4ab11bd3e6ee6297a90759d1");
            }
            catch (Exception ex) {
                this.scriptError("\u5bf9\u4e0d\u8d77\uff0c\u7531\u4e8e\u60a8\u975e\u6cd5\u63d0\u4ea4\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u88ab\u62d2\u7edd.");
                Enumeration<String> files = this.ac.getFileNames();
                if (files != null) {
                    while (files.hasMoreElements()) {
                        File f = this.ac.getFile(files.nextElement());
                        if (f == null) continue;
                        f.delete();
                    }
                }
                return;
            }
            boolean isJDiyTable = true;
            Rs rs = this.dao.rs(new Args("jdiy_tb", "tb='" + table + "'", "flag"));
            if (!rs.isNull()) {
                isJDiyTable = !rs.getBoolean("flag");
            }
            Rs persist = "".equals(id) ? this.dao.rs(new Args(table, "1=0")) : this.dao.rs(new Args(table, pk + "='" + id + "'"));
            persist.setPK(pk);
            if (persist.isNull()) {
                if (isJDiyTable) {
                    if ("".equals(id)) {
                        persist.set(pk, Rs.newId());
                    }
                    persist.set("isc", "0");
                    persist.set("sort", "100");
                    persist.set("hits", "0");
                    persist.set("owner", this.ac.var("userId"));
                    Date now = new Date();
                    persist.set("dt1", now);
                    persist.set("dt2", now);
                }
                if (!"".equals(id)) {
                    persist.set(pk, id);
                }
            }
            String[] cols = persist.getCols();
            String[] colsX = px == null ? new String[]{} : Txt.split(px, ",");
            Enumeration<String> enn = this.ac.getNames();
            while (enn.hasMoreElements()) {
                String n = enn.nextElement();
                String valstr = this.ac.get(n);
                if (n.equals(pk)) continue;
                if (Fn.containsIgnoreCase(cols, n)) {
                    if (valstr == null) {
                        valstr = "";
                    }
                    persist.set(n, valstr);
                    continue;
                }
                if (!Fn.containsIgnoreCase(colsX, n)) continue;
                persist.setX(n, valstr);
            }
            this.saveToDatabase(persist, isJDiyTable);
            if (!"".equals(persist.get(pk))) {
                this.saveToFile(persist);
            }
            this.doBack("successUpdate", id, this.ac.getSign(persist.toString()));
        }
        finally {
            Enumeration<String> files = this.ac.getFileNames();
            if (files != null) {
                while (files.hasMoreElements()) {
                    File f = this.ac.getFile(files.nextElement());
                    if (f == null) continue;
                    f.delete();
                }
            }
        }
    }

    private void saveToDatabase(Rs persist, boolean isJDiyTable) throws SQLException, IOException {
        if (isJDiyTable) {
            Args args;
            Rs td;
            if (persist.get("tid").equals("")) {
                throw new JDiyFieldException("\u672a\u6307\u5b9atid");
            }
            String frame = ".";
            if (!persist.get("tid").equals("0000000000") && !(td = this.dao.rs(args = new Args(persist.getTable(), "id='" + persist.get("tid") + "'", "frame, t0"))).isNull()) {
                frame = td.get("frame") + persist.get("tid") + ".";
            }
            String oldFrame = persist.get("frame");
            persist.set("frame", frame);
            if (!persist.isNull() && persist.getBoolean("isc")) {
                this.dao.exec(Nativesql.getInstance(this.dao.getDbType()).getUpFrameSql(persist.getTable(), persist.get("id"), oldFrame, frame));
            }
        }
        this.dao.save(persist);
    }

    private void saveToFile(Rs persist) throws IOException {
        String vPath = this.getJDiyDataPath() + File.separator + "entity";
        String path1 = vPath + File.separator + persist.get(persist.getPK()[0]).substring(persist.get(persist.getPK()[0]).length() - 1);
        String path = path1 + File.separator + persist.get(persist.getPK()[0]);
        Enumeration<String> files = this.ac.getFileNames();
        if (files != null) {
            new File(path).mkdirs();
            while (files.hasMoreElements()) {
                String syName;
                String fn;
                String inputName = files.nextElement();
                String string = fn = inputName.contains("@") ? inputName.substring(0, inputName.indexOf(64)) : inputName;
                File f = this.ac.getFile(inputName);
                if (f == null || !f.exists()) continue;
                if (f.length() == 0L) {
                    f.delete();
                    continue;
                }
                String ext = f.getName().substring(f.getName().lastIndexOf(".") + 1).toLowerCase();
                if (Fn.containsIgnoreCase(disabledExt, ext)) {
                    f.delete();
                    throw new JDiySecurityException("\u7cfb\u7edf\u7981\u6b62\u60a8\u4e0a\u4f20\u6307\u5b9a\u7684\u6587\u4ef6\u7c7b\u578b\uff1a" + ext);
                }
                String shortName = this.ac.get(fn + "_shortName");
                if (shortName == null || shortName.equals("")) {
                    shortName = fn;
                }
                if ((syName = this.ac.get(fn + "_syName")) == null || syName.equals("")) {
                    syName = fn;
                }
                String fName = f.getName();
                String fExt = fName.substring(fName.lastIndexOf("."));
                File f1 = null;
                File f2 = null;
                if (".jpg:.gif:.png:.jpeg:.bmp".contains(fExt.toLowerCase())) {
                    File syf;
                    String syImg;
                    String shortWH = this.ac.get(fn + "_shortWH");
                    Pic jp = null;
                    if (shortWH != null && !shortWH.equals("")) {
                        String[] wh = Txt.split(shortWH, ",");
                        int w = Txt.parseInt(wh[0]);
                        int h = Txt.parseInt(wh[1]);
                        jp = new Pic(f);
                        if (jp.getWidth() != w || jp.getHeight() != h) {
                            if (this.ac.getInt(fn + "_shortLock") == 1) {
                                jp.resizeBy(w, h);
                            } else {
                                jp.resizeTo(w, h);
                            }
                            if (fn.equals(shortName)) {
                                jp.saveAs(f);
                            } else {
                                String p = f.getParent() + File.separator + shortName;
                                new File(p).mkdirs();
                                f1 = new File(p + File.separator + fName);
                                jp.saveAs(f1);
                            }
                        } else if (!fn.equals(shortName)) {
                            f1 = f;
                        }
                    }
                    if ((syImg = this.ac.get(fn + "_syImg")) != null && !syImg.equals("") && ((syf = new File(this.request.getSession().getServletContext().getRealPath(syImg))).exists() || syf.isFile())) {
                        syImg = syf.getAbsolutePath();
                        if (jp == null) {
                            jp = new Pic(f1 == null ? f : f1);
                        }
                        jp.add(new File(syImg), this.ac.getInt(fn + "_syPosition", 9));
                        if (fn.equals(syName)) {
                            jp.saveAs(f);
                        } else {
                            String p = f.getParent() + File.separator + syName;
                            new File(p).mkdirs();
                            f2 = new File(p + File.separator + fName);
                            jp.saveAs(f2);
                            if (f2.equals(f1)) {
                                f2 = null;
                            }
                        }
                    }
                }
                if ("1".equals(this.ac.get(fn + "_expand"))) {
                    persist.addF(fn, f).addF(shortName, f1).addF(syName, f2);
                } else {
                    persist.setF(fn, f);
                    if (f1 != null) {
                        persist.setF(shortName, f1);
                    }
                    if (f2 != null) {
                        persist.setF(syName, f2);
                    }
                }
                this.dao.save(persist);
                f.delete();
                if (f1 != null) {
                    f1.delete();
                    Fs.delEmpty(f1.getParentFile());
                }
                if (f2 == null) continue;
                f2.delete();
                Fs.delEmpty(f2.getParentFile());
            }
        }
        Fs.delEmpty(path);
        Fs.delEmpty(path1);
        Fs.delEmpty(vPath);
    }
}

