/*
 * Decompiled with CFR 0.152.
 */
package net.jdiy.web.nativesql;

import java.util.HashMap;
import java.util.Map;
import net.jdiy.core.Dao;
import net.jdiy.core.ex.JDiyUnSupportException;
import net.jdiy.core.res.Locale;

public abstract class Nativesql {
    public static final Map<String, String> _names = new HashMap<String, String>();
    private static Map<String, Nativesql> nativeQueryCache = new HashMap<String, Nativesql>();

    public static synchronized Nativesql getInstance(String dbType) {
        Nativesql nt = nativeQueryCache.get(dbType);
        if (nt == null) {
            try {
                Class<?> C = Class.forName("net.jdiy.web.nativesql." + _names.get(dbType.toLowerCase()));
                nt = (Nativesql)C.newInstance();
            }
            catch (Exception ex) {
                throw new JDiyUnSupportException(Locale.DBG.getString("err.database.dbtype"), dbType);
            }
            nativeQueryCache.put(dbType, nt);
        }
        return nt;
    }

    public abstract String getUpFrameSql(String var1, String var2, String var3, String var4);

    public abstract void createTable(Dao var1, String var2);

    public String getLikeFilter(String field, String key) {
        return field + " LIKE '%" + key + "%'";
    }

    public String getDTFilter(String dtB, String dtE, String fieldName) {
        StringBuilder sb = new StringBuilder();
        if (!"".equals(dtB)) {
            sb.append(" AND ").append(fieldName).append(">='").append(dtB).append("'");
        }
        if (!"".equals(dtE)) {
            sb.append(" AND ").append(fieldName).append("<='").append(dtE).append("'");
        }
        return sb.toString();
    }

    static {
        _names.put("mysql", "MySQL");
        _names.put("mssql", "MsSQL");
        _names.put("postgresql", "PostgreSQL");
        _names.put("oracle", "Oracle");
        _names.put("sqlite", "SQLite");
        _names.put("db2", "DB2");
    }
}

