/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.am;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class LicenseEntry
implements Serializable {
    private static final long serialVersionUID = 6360267333959868353L;
    public static final String LICENSE_TYPE_ZS_STRING = "ZS";
    public static final String LICENSE_TYPE_IS_STRING = "IS";
    public static final String LICENSE_TYPE_TL_STRING = "TL";
    public static final String LICENSE_TYPE_LUW_STRING = "LUW";
    public static final int LICENSE_TYPE = 0;
    public static final int LICENSE_TYPE_TL = 1;
    public static final int CALL_SP = 1;
    public static final int CALL_UDF = 2;
    public static final int CURRENT_LICENSEDISKFILE_VERSION = 0;
    public static final int LICENSE_LEASE_PERIOD_SP = 7;
    public static final int LICENSE_LEASE_PERIOD_UDF = 90;
    private static final String key = "key";
    private String server_ = null;
    private int port_ = 0;
    private String databaseName_ = null;
    private String key_ = null;
    private long lastActivationTime_ = 0L;
    private String retval_ = null;
    private String[] licenseType_ = new String[2];
    private long[] expirationDate_ = new long[2];
    private int version_ = 0;
    private String controllerURL_ = null;
    private static final DateFormat dateFormat__ = new SimpleDateFormat("MMddyy");
    private static Calendar calendar_ = null;

    public LicenseEntry(String string, int n2, String string2, String[] stringArray, long[] lArray, long l2, int n3, String string3, String string4) {
        this.server_ = string;
        this.port_ = n2;
        this.databaseName_ = string2;
        this.licenseType_ = stringArray;
        this.key_ = this.server_ + ":" + this.port_ + ":" + this.databaseName_;
        this.expirationDate_ = lArray;
        this.lastActivationTime_ = l2;
        this.version_ = n3;
        this.controllerURL_ = string3;
        this.retval_ = string4;
    }

    public String getKey() {
        return this.key_;
    }

    public String getServerName() {
        return this.server_;
    }

    public int getPort() {
        return this.port_;
    }

    public String getDatabaseName() {
        return this.databaseName_;
    }

    public String getLastReturnedValue() {
        return this.retval_;
    }

    public long getLastActivationTime() {
        return this.lastActivationTime_;
    }

    public String[] getLicenseType() {
        return this.licenseType_;
    }

    public long[] getExpirationDate() {
        return this.expirationDate_;
    }

    public int getVersion() {
        return this.version_;
    }

    public String getControllerURL() {
        return this.controllerURL_;
    }

    public synchronized void update(String[] stringArray, long[] lArray, String string, long l2, int n2, String string2) {
        this.licenseType_ = stringArray;
        this.expirationDate_ = lArray;
        this.lastActivationTime_ = l2;
        this.retval_ = string;
        this.version_ = n2;
        this.controllerURL_ = string2;
    }

    public synchronized void updateLastActivationTime(long l2) {
        this.lastActivationTime_ = l2;
    }

    public synchronized void updateReturnValue(String string) {
        this.retval_ = string;
    }

    public synchronized void updateLicenseType(String[] stringArray) {
        this.licenseType_ = stringArray;
    }

    public synchronized void updateExpirationDate(long[] lArray) {
        this.expirationDate_ = lArray;
    }

    public synchronized boolean checkIfLeaseTimeExpired() {
        return LicenseEntry.checkIfLeaseTimeExpired(this.expirationDate_);
    }

    protected static Object[] validateLicense(String string, int n2, int n3) {
        Object[] objectArray;
        String[] stringArray = new String[2];
        long[] lArray = new long[2];
        String string2 = null;
        Object var6_6 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("L:")) {
                    string2 = LicenseEntry.decryptLicenseToken(string3.substring(2));
                    if (string2.startsWith(LICENSE_TYPE_ZS_STRING)) {
                        stringArray[0] = LICENSE_TYPE_ZS_STRING;
                        lArray[0] = LicenseEntry.addDaysToLease(n2);
                        continue;
                    }
                    if (string2.startsWith(LICENSE_TYPE_IS_STRING)) {
                        stringArray[0] = LICENSE_TYPE_IS_STRING;
                        lArray[0] = LicenseEntry.addDaysToLease(n2);
                        continue;
                    }
                    if (!string2.startsWith(LICENSE_TYPE_TL_STRING)) continue;
                    stringArray[1] = LICENSE_TYPE_TL_STRING;
                    Date date = null;
                    try {
                        date = dateFormat__.parse(string2.substring(6));
                    }
                    catch (ParseException parseException) {
                        date = null;
                    }
                    lArray[1] = LicenseEntry.addDaysToLease(date, 1);
                    continue;
                }
                if (string3.startsWith("C:") || !string3.startsWith("c:")) continue;
            }
        }
        if (n3 == 4) {
            stringArray[0] = LICENSE_TYPE_LUW_STRING;
            lArray[0] = LicenseEntry.addDaysToLease(n2);
        }
        if (!LicenseEntry.checkIfLeaseTimeExpired(lArray)) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = stringArray;
            objectArray2[1] = lArray;
            objectArray = objectArray2;
            objectArray2[2] = var6_6;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    protected String getLicenseErrorMessage() {
        String string = null;
        if (this.expirationDate_[0] == 0L && this.expirationDate_[1] == 0L) {
            string = "No valid server license found.";
        } else if (this.expirationDate_[1] > 0L) {
            Date date = new Date(this.expirationDate_[1]);
            string = "Trial license expired on " + date.toString();
        } else {
            string = "Unable to validate server license.";
        }
        return string;
    }

    private static boolean checkIfLeaseTimeExpired(long[] lArray) {
        boolean bl2 = true;
        long l2 = System.currentTimeMillis();
        if (lArray != null) {
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                if (l2 >= lArray[i2]) continue;
                return false;
            }
        }
        return bl2;
    }

    private static Calendar getCalendar() {
        if (calendar_ == null) {
            calendar_ = Calendar.getInstance();
        }
        return calendar_;
    }

    private static long addDaysToLease(Date date, int n2) {
        Calendar calendar = LicenseEntry.getCalendar();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime().getTime();
    }

    private static long addDaysToLease(int n2) {
        int n3 = 0;
        if (n2 == 1) {
            n3 = 7;
        } else if (n2 == 2) {
            n3 = 90;
        }
        long l2 = System.currentTimeMillis();
        return l2 += 86400000L * (long)n3;
    }

    private static String decryptLicenseToken(String string) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(16);
        int n3 = key.length();
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            byte by = (byte)string.charAt(i2);
            by = (byte)(by - 64);
            by = (byte)(by << 4);
            byte by2 = (byte)string.charAt(i2 + 1);
            by2 = (byte)(by2 - 64);
            by = (byte)(by + by2);
            int n4 = by ^ key.charAt(n2);
            stringBuffer.append((char)n4);
            if (++n2 < n3) continue;
            n2 = 0;
        }
        return stringBuffer.toString();
    }
}

