/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.xml.ParseSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class TransformSupport
extends BodyTagSupport {
    protected Object xml;
    protected String xmlSystemId;
    protected Object xslt;
    protected String xsltSystemId;
    protected Result result;
    private String var;
    private int scope;
    private Transformer t;
    private TransformerFactory tf;
    private DocumentBuilder db;
    private DocumentBuilderFactory dbf;

    public TransformSupport() {
        this.init();
    }

    private void init() {
        this.xslt = null;
        this.xml = null;
        this.xsltSystemId = null;
        this.xmlSystemId = null;
        this.var = null;
        this.result = null;
        this.tf = null;
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        try {
            if (this.dbf == null) {
                this.dbf = DocumentBuilderFactory.newInstance();
                this.dbf.setNamespaceAware(true);
                this.dbf.setValidating(false);
            }
            if (this.db == null) {
                this.db = this.dbf.newDocumentBuilder();
            }
            if (this.tf == null) {
                this.tf = TransformerFactory.newInstance();
            }
            if (this.xslt != null) {
                if (!(this.xslt instanceof String || this.xslt instanceof Reader || this.xslt instanceof Source)) {
                    throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_UNRECOGNIZED"));
                }
            } else {
                throw new JspTagException(Resources.getMessage("TRANSFORM_NO_TRANSFORMER"));
            }
            Source source = this.getSource(this.xslt, this.xsltSystemId);
            this.tf.setURIResolver(new JstlUriResolver(this.pageContext));
            this.t = this.tf.newTransformer(source);
            return 2;
        }
        catch (SAXException sAXException) {
            throw new JspException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new JspException((Throwable)transformerConfigurationException);
        }
    }

    public int doEndTag() throws JspException {
        try {
            Object object = this.xml;
            if (object == null) {
                object = this.bodyContent != null && this.bodyContent.getString() != null ? this.bodyContent.getString().trim() : "";
            }
            Source source = this.getSource(object, this.xmlSystemId);
            if (this.result != null) {
                this.t.transform(source, this.result);
            } else if (this.var != null) {
                Document document = this.db.newDocument();
                DOMResult dOMResult = new DOMResult(document);
                this.t.transform(source, dOMResult);
                this.pageContext.setAttribute(this.var, (Object)document, this.scope);
            } else {
                StreamResult streamResult = new StreamResult(new SafeWriter((Writer)this.pageContext.getOut()));
                this.t.transform(source, streamResult);
            }
            return 6;
        }
        catch (SAXException sAXException) {
            throw new JspException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
        catch (TransformerException transformerException) {
            throw new JspException((Throwable)transformerException);
        }
    }

    public void release() {
        this.init();
    }

    public void addParameter(String string, Object object) {
        this.t.setParameter(string, object);
    }

    private static String wrapSystemId(String string) {
        if (string == null) {
            return "jstl:";
        }
        if (ImportSupport.isAbsoluteUrl(string)) {
            return string;
        }
        return "jstl:" + string;
    }

    private Source getSource(Object object, String string) throws SAXException, ParserConfigurationException, IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof Source) {
            return (Source)object;
        }
        if (object instanceof String) {
            return this.getSource(new StringReader((String)object), string);
        }
        if (object instanceof Reader) {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(new ParseSupport.JstlEntityResolver(this.pageContext));
            InputSource inputSource = new InputSource((Reader)object);
            inputSource.setSystemId(TransformSupport.wrapSystemId(string));
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            sAXSource.setSystemId(TransformSupport.wrapSystemId(string));
            return sAXSource;
        }
        if (object instanceof Node) {
            return new DOMSource((Node)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 1) {
                return this.getSource(list.get(0), string);
            }
            throw new IllegalArgumentException(Resources.getMessage("TRANSFORM_SOURCE_INVALID_LIST"));
        }
        throw new IllegalArgumentException(Resources.getMessage("TRANSFORM_SOURCE_UNRECOGNIZED") + object.getClass());
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    private static class JstlUriResolver
    implements URIResolver {
        private final PageContext ctx;

        public JstlUriResolver(PageContext pageContext) {
            this.ctx = pageContext;
        }

        public Source resolve(String string, String string2) throws TransformerException {
            InputStream inputStream;
            int n;
            if (string == null) {
                return null;
            }
            if (string2 != null && (n = string2.indexOf("jstl:")) != -1) {
                string2 = string2.substring(n + 5);
            }
            if (ImportSupport.isAbsoluteUrl(string) || string2 != null && ImportSupport.isAbsoluteUrl(string2)) {
                return null;
            }
            String string3 = (string2 = string2 == null || string2.lastIndexOf("/") == -1 ? "" : string2.substring(0, string2.lastIndexOf("/") + 1)) + string;
            if (string3.startsWith("/")) {
                inputStream = this.ctx.getServletContext().getResourceAsStream(string3);
                if (inputStream == null) {
                    throw new TransformerException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", string));
                }
            } else {
                String string4 = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String string5 = string4.substring(0, string4.lastIndexOf("/"));
                inputStream = this.ctx.getServletContext().getResourceAsStream(string5 + "/" + string3);
                if (inputStream == null) {
                    throw new TransformerException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", string));
                }
            }
            return new StreamSource(inputStream);
        }
    }

    private static class SafeWriter
    extends Writer {
        private Writer w;

        public SafeWriter(Writer writer) {
            this.w = writer;
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.w.write(cArray, n, n2);
        }
    }
}

