/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.HouseKeeper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.ProxoolException;

public class HouseKeeperThread
extends Thread {
    private static final Log LOG = LogFactory.getLog((Class)HouseKeeperThread.class);
    private boolean stop;

    public HouseKeeperThread(String name) {
        this.setDaemon(true);
        this.setName(name);
    }

    public void run() {
        while (!this.stop) {
            HouseKeeper hk = HouseKeeperController.getHouseKeeperToRun();
            while (hk != null && !this.stop) {
                try {
                    hk.sweep();
                }
                catch (ProxoolException e) {
                    LOG.error((Object)("Couldn't sweep " + hk.getAlias()), (Throwable)e);
                }
                hk = HouseKeeperController.getHouseKeeperToRun();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted", (Throwable)e);
            }
        }
    }

    protected void cancel() {
        this.stop = true;
    }
}

