/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletParamValuesMap
implements Map<String, String[]> {
    private ServletRequest request = null;

    public ServletParamValuesMap(ServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getParameter(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String[])) {
            return false;
        }
        String[] test = (String[])value;
        for (String[] actual : this.values()) {
            if (test.length != actual.length) continue;
            boolean matched = true;
            for (int i = 0; i < test.length; ++i) {
                if (test[i].equals(actual[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        HashSet<Map.Entry<String, String[]>> set = new HashSet<Map.Entry<String, String[]>>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add(new MapEntry<String, String[]>(key, this.request.getParameterValues(key), false));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.request.equals(o);
    }

    @Override
    public String[] get(Object key) {
        return this.request.getParameterValues(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public String[] put(String key, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String[]> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<String[]> values() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            list.add(this.request.getParameterValues((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

