/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.AbstractAttribute;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeAttribute
extends AbstractAttribute
implements SerializationContext,
ValidationContext {
    private Element parent;
    private QName qname;
    private XSDatatype datatype;
    private Object data;
    private String text;

    public DatatypeAttribute(QName qName, XSDatatype xSDatatype) {
        this.qname = qName;
        this.datatype = xSDatatype;
    }

    public DatatypeAttribute(QName qName, XSDatatype xSDatatype, String string) {
        this.qname = qName;
        this.datatype = xSDatatype;
        this.text = string;
        this.data = this.convertToValue(string);
    }

    public String toString() {
        return this.getClass().getName() + this.hashCode() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\" data: " + this.getData() + "]";
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    public String getNamespacePrefix(String string) {
        Namespace namespace;
        Element element = this.getParent();
        if (element != null && (namespace = element.getNamespaceForURI(string)) != null) {
            return namespace.getPrefix();
        }
        return null;
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isNotation(String string) {
        return false;
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public String resolveNamespacePrefix(String string) {
        Namespace namespace;
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespaceURI();
        }
        Element element = this.getParent();
        if (element != null && (namespace = element.getNamespaceForPrefix(string)) != null) {
            return namespace.getURI();
        }
        return null;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getValue() {
        return this.text;
    }

    public void setValue(String string) {
        this.validate(string);
        this.text = string;
        this.data = this.convertToValue(string);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        String string = this.datatype.convertToLexicalValue(object, (SerializationContext)this);
        this.validate(string);
        this.text = string;
        this.data = object;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public boolean supportsParent() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void validate(String string) throws IllegalArgumentException {
        try {
            this.datatype.checkValid(string, (ValidationContext)this);
        }
        catch (DatatypeException datatypeException) {
            throw new IllegalArgumentException(datatypeException.getMessage());
        }
    }

    protected Object convertToValue(String string) {
        if (this.datatype instanceof DatabindableDatatype) {
            XSDatatype xSDatatype = this.datatype;
            return xSDatatype.createJavaObject(string, (ValidationContext)this);
        }
        return this.datatype.createValue(string, (ValidationContext)this);
    }
}

