/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.SchemaParser;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DatatypeDocumentFactory
extends DocumentFactory {
    private static final boolean DO_INTERN_QNAME = false;
    protected static transient DatatypeDocumentFactory singleton = new DatatypeDocumentFactory();
    private static final Namespace XSI_NAMESPACE = Namespace.get("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName XSI_SCHEMA_LOCATION = QName.get("schemaLocation", XSI_NAMESPACE);
    private static final QName XSI_NO_SCHEMA_LOCATION = QName.get("noNamespaceSchemaLocation", XSI_NAMESPACE);
    private SchemaParser schemaBuilder;
    private SAXReader xmlSchemaReader = new SAXReader();
    private boolean autoLoadSchema = true;

    public DatatypeDocumentFactory() {
        this.schemaBuilder = new SchemaParser(this);
    }

    public static DocumentFactory getInstance() {
        return singleton;
    }

    public void loadSchema(Document document) {
        this.schemaBuilder.build(document);
    }

    public void loadSchema(Document document, Namespace namespace) {
        this.schemaBuilder.build(document, namespace);
    }

    public DatatypeElementFactory getElementFactory(QName qName) {
        DatatypeElementFactory datatypeElementFactory = null;
        DocumentFactory documentFactory = qName.getDocumentFactory();
        if (documentFactory instanceof DatatypeElementFactory) {
            datatypeElementFactory = (DatatypeElementFactory)documentFactory;
        }
        return datatypeElementFactory;
    }

    public Attribute createAttribute(Element element, QName qName, String string) {
        if (this.autoLoadSchema && qName.equals(XSI_NO_SCHEMA_LOCATION)) {
            Document document = element != null ? element.getDocument() : null;
            this.loadSchema(document, string);
        } else if (this.autoLoadSchema && qName.equals(XSI_SCHEMA_LOCATION)) {
            Document document = element != null ? element.getDocument() : null;
            String string2 = string.substring(0, string.indexOf(32));
            Namespace namespace = element.getNamespaceForURI(string2);
            this.loadSchema(document, string.substring(string.indexOf(32) + 1), namespace);
        }
        return super.createAttribute(element, qName, string);
    }

    protected void loadSchema(Document document, String string) {
        try {
            EntityResolver entityResolver = document.getEntityResolver();
            if (entityResolver == null) {
                String string2 = "No EntityResolver available for resolving URI: ";
                throw new InvalidSchemaException(string2 + string);
            }
            InputSource inputSource = entityResolver.resolveEntity(null, string);
            if (entityResolver == null) {
                throw new InvalidSchemaException("Could not resolve the URI: " + string);
            }
            Document document2 = this.xmlSchemaReader.read(inputSource);
            this.loadSchema(document2);
        }
        catch (Exception exception) {
            System.out.println("Failed to load schema: " + string);
            System.out.println("Caught: " + exception);
            exception.printStackTrace();
            throw new InvalidSchemaException("Failed to load schema: " + string);
        }
    }

    protected void loadSchema(Document document, String string, Namespace namespace) {
        try {
            EntityResolver entityResolver = document.getEntityResolver();
            if (entityResolver == null) {
                String string2 = "No EntityResolver available for resolving URI: ";
                throw new InvalidSchemaException(string2 + string);
            }
            InputSource inputSource = entityResolver.resolveEntity(null, string);
            if (entityResolver == null) {
                throw new InvalidSchemaException("Could not resolve the URI: " + string);
            }
            Document document2 = this.xmlSchemaReader.read(inputSource);
            this.loadSchema(document2, namespace);
        }
        catch (Exception exception) {
            System.out.println("Failed to load schema: " + string);
            System.out.println("Caught: " + exception);
            exception.printStackTrace();
            throw new InvalidSchemaException("Failed to load schema: " + string);
        }
    }
}

