/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeElementFactory;

class NamedTypeResolver {
    protected Map complexTypeMap = new HashMap();
    protected Map simpleTypeMap = new HashMap();
    protected Map typedElementMap = new HashMap();
    protected Map elementFactoryMap = new HashMap();
    protected DocumentFactory documentFactory;

    NamedTypeResolver(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    void registerComplexType(QName qName, DocumentFactory documentFactory) {
        this.complexTypeMap.put(qName, documentFactory);
    }

    void registerSimpleType(QName qName, XSDatatype xSDatatype) {
        this.simpleTypeMap.put(qName, xSDatatype);
    }

    void registerTypedElement(Element element, QName qName, DocumentFactory documentFactory) {
        this.typedElementMap.put(element, qName);
        this.elementFactoryMap.put(element, documentFactory);
    }

    void resolveElementTypes() {
        Iterator iterator = this.typedElementMap.keySet().iterator();
        while (iterator.hasNext()) {
            DocumentFactory documentFactory;
            Element element = (Element)iterator.next();
            QName qName = this.getQNameOfSchemaElement(element);
            QName qName2 = (QName)this.typedElementMap.get(element);
            if (this.complexTypeMap.containsKey(qName2)) {
                documentFactory = (DocumentFactory)this.complexTypeMap.get(qName2);
                qName.setDocumentFactory(documentFactory);
                continue;
            }
            if (!this.simpleTypeMap.containsKey(qName2)) continue;
            documentFactory = (XSDatatype)this.simpleTypeMap.get(qName2);
            DocumentFactory documentFactory2 = (DocumentFactory)this.elementFactoryMap.get(element);
            if (!(documentFactory2 instanceof DatatypeElementFactory)) continue;
            ((DatatypeElementFactory)documentFactory2).setChildElementXSDatatype(qName, (XSDatatype)documentFactory);
        }
    }

    void resolveNamedTypes() {
        this.resolveElementTypes();
    }

    private QName getQNameOfSchemaElement(Element element) {
        String string = element.attributeValue("name");
        return this.getQName(string);
    }

    private QName getQName(String string) {
        return this.documentFactory.createQName(string);
    }
}

