/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.DefaultDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMDocument
extends DefaultDocument
implements Document {
    private static final DOMDocumentFactory DOCUMENT_FACTORY = (DOMDocumentFactory)DOMDocumentFactory.getInstance();

    public DOMDocument() {
        this.init();
    }

    public DOMDocument(String string) {
        super(string);
        this.init();
    }

    public DOMDocument(DOMElement dOMElement) {
        super(dOMElement);
        this.init();
    }

    public DOMDocument(DOMDocumentType dOMDocumentType) {
        super(dOMDocumentType);
        this.init();
    }

    public DOMDocument(DOMElement dOMElement, DOMDocumentType dOMDocumentType) {
        super(dOMElement, dOMDocumentType);
        this.init();
    }

    public DOMDocument(String string, DOMElement dOMElement, DOMDocumentType dOMDocumentType) {
        super(string, dOMElement, dOMDocumentType);
        this.init();
    }

    private void init() {
        this.setDocumentFactory(DOCUMENT_FACTORY);
    }

    public boolean supports(String string, String string2) {
        return DOMNodeHelper.supports(this, string, string2);
    }

    public String getNamespaceURI() {
        return DOMNodeHelper.getNamespaceURI(this);
    }

    public String getPrefix() {
        return DOMNodeHelper.getPrefix(this);
    }

    public void setPrefix(String string) throws DOMException {
        DOMNodeHelper.setPrefix(this, string);
    }

    public String getLocalName() {
        return DOMNodeHelper.getLocalName(this);
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    public Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(this.node(0));
    }

    public Node getLastChild() {
        return DOMNodeHelper.asDOMNode(this.node(this.nodeCount() - 1));
    }

    public Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    public Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.insertBefore(this, node, node2);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.replaceChild(this, node, node2);
    }

    public Node removeChild(Node node) throws DOMException {
        return DOMNodeHelper.removeChild(this, node);
    }

    public Node appendChild(Node node) throws DOMException {
        this.checkNewChildNode(node);
        return DOMNodeHelper.appendChild(this, node);
    }

    private void checkNewChildNode(Node node) throws DOMException {
        short s = node.getNodeType();
        if (s != 1 && s != 8 && s != 7 && s != 10) {
            throw new DOMException(3, "Given node cannot be a child of document");
        }
    }

    public boolean hasChildNodes() {
        return this.nodeCount() > 0;
    }

    public Node cloneNode(boolean bl) {
        return DOMNodeHelper.cloneNode(this, bl);
    }

    public boolean isSupported(String string, String string2) {
        return DOMNodeHelper.isSupported(this, string, string2);
    }

    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    public NodeList getElementsByTagName(String string) {
        ArrayList arrayList = new ArrayList();
        DOMNodeHelper.appendElementsByTagName(arrayList, this, string);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        DOMNodeHelper.appendElementsByTagNameNS(arrayList, this, string, string2);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    public DocumentType getDoctype() {
        return DOMNodeHelper.asDOMDocumentType(this.getDocType());
    }

    public DOMImplementation getImplementation() {
        if (this.getDocumentFactory() instanceof DOMImplementation) {
            return (DOMImplementation)((Object)this.getDocumentFactory());
        }
        return DOCUMENT_FACTORY;
    }

    public Element getDocumentElement() {
        return DOMNodeHelper.asDOMElement(this.getRootElement());
    }

    public Element createElement(String string) throws DOMException {
        return (Element)((Object)this.getDocumentFactory().createElement(string));
    }

    public DocumentFragment createDocumentFragment() {
        DOMNodeHelper.notSupported();
        return null;
    }

    public Text createTextNode(String string) {
        return (Text)((Object)this.getDocumentFactory().createText(string));
    }

    public Comment createComment(String string) {
        return (Comment)((Object)this.getDocumentFactory().createComment(string));
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return (CDATASection)((Object)this.getDocumentFactory().createCDATA(string));
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return (ProcessingInstruction)((Object)this.getDocumentFactory().createProcessingInstruction(string, string2));
    }

    public Attr createAttribute(String string) throws DOMException {
        QName qName = this.getDocumentFactory().createQName(string);
        return (Attr)((Object)this.getDocumentFactory().createAttribute(null, qName, ""));
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return (EntityReference)((Object)this.getDocumentFactory().createEntity(string, null));
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        DOMNodeHelper.notSupported();
        return null;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        QName qName = this.getDocumentFactory().createQName(string2, string);
        return (Element)((Object)this.getDocumentFactory().createElement(qName));
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        QName qName = this.getDocumentFactory().createQName(string2, string);
        return (Attr)((Object)this.getDocumentFactory().createAttribute(null, qName, null));
    }

    public Element getElementById(String string) {
        return DOMNodeHelper.asDOMElement(this.elementByID(string));
    }

    protected DocumentFactory getDocumentFactory() {
        if (super.getDocumentFactory() == null) {
            return DOCUMENT_FACTORY;
        }
        return super.getDocumentFactory();
    }
}

