/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.DispatchHandler;

class ElementStack
implements ElementPath {
    protected Element[] stack;
    protected int lastElementIndex = -1;
    private DispatchHandler handler = null;

    public ElementStack() {
        this(50);
    }

    public ElementStack(int n) {
        this.stack = new Element[n];
    }

    public void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.handler = dispatchHandler;
    }

    public DispatchHandler getDispatchHandler() {
        return this.handler;
    }

    public void clear() {
        this.lastElementIndex = -1;
    }

    public Element peekElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex];
    }

    public Element popElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex--];
    }

    public void pushElement(Element element) {
        int n = this.stack.length;
        if (++this.lastElementIndex >= n) {
            this.reallocate(n * 2);
        }
        this.stack[this.lastElementIndex] = element;
    }

    protected void reallocate(int n) {
        Element[] elementArray = this.stack;
        this.stack = new Element[n];
        System.arraycopy(elementArray, 0, this.stack, 0, elementArray.length);
    }

    public int size() {
        return this.lastElementIndex + 1;
    }

    public Element getElement(int n) {
        Element element;
        try {
            element = this.stack[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            element = null;
        }
        return element;
    }

    public String getPath() {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        return this.handler.getPath();
    }

    public Element getCurrent() {
        return this.peekElement();
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.handler.addHandler(this.getHandlerPath(string), elementHandler);
    }

    public void removeHandler(String string) {
        this.handler.removeHandler(this.getHandlerPath(string));
    }

    public boolean containsHandler(String string) {
        return this.handler.containsHandler(string);
    }

    private String getHandlerPath(String string) {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        String string2 = string.startsWith("/") ? string : (this.getPath().equals("/") ? this.getPath() + string : this.getPath() + "/" + string);
        return string2;
    }
}

