/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class HTMLWriter
extends XMLWriter {
    private static String lineSeparator = System.getProperty("line.separator");
    protected static final HashSet DEFAULT_PREFORMATTED_TAGS = new HashSet();
    protected static final OutputFormat DEFAULT_HTML_FORMAT;
    private Stack formatStack = new Stack();
    private String lastText = "";
    private int tagsOuput = 0;
    private int newLineAfterNTags = -1;
    private HashSet preformattedTags = DEFAULT_PREFORMATTED_TAGS;
    private HashSet omitElementCloseSet;

    public HTMLWriter(Writer writer) {
        super(writer, DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
    }

    public HTMLWriter() throws UnsupportedEncodingException {
        super(DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(OutputFormat outputFormat) throws UnsupportedEncodingException {
        super(outputFormat);
    }

    public HTMLWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(outputStream, DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        super(outputStream, outputFormat);
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    protected void writeCDATA(String string) throws IOException {
        if (this.getOutputFormat().isXHTML()) {
            super.writeCDATA(string);
        } else {
            this.writer.write(string);
        }
        this.lastOutputNodeType = 4;
    }

    protected void writeEntity(Entity entity) throws IOException {
        this.writer.write(entity.getText());
        this.lastOutputNodeType = 5;
    }

    protected void writeDeclaration() throws IOException {
    }

    protected void writeString(String string) throws IOException {
        if (string.equals("\n")) {
            if (!this.formatStack.empty()) {
                super.writeString(lineSeparator);
            }
            return;
        }
        this.lastText = string;
        if (this.formatStack.empty()) {
            super.writeString(string.trim());
        } else {
            super.writeString(string);
        }
    }

    protected void writeClose(String string) throws IOException {
        if (!this.omitElementClose(string)) {
            super.writeClose(string);
        }
    }

    protected void writeEmptyElementClose(String string) throws IOException {
        if (this.getOutputFormat().isXHTML()) {
            if (this.omitElementClose(string)) {
                this.writer.write(" />");
            } else {
                super.writeEmptyElementClose(string);
            }
        } else if (this.omitElementClose(string)) {
            this.writer.write(">");
        } else {
            super.writeEmptyElementClose(string);
        }
    }

    protected boolean omitElementClose(String string) {
        return this.internalGetOmitElementCloseSet().contains(string.toUpperCase());
    }

    private HashSet internalGetOmitElementCloseSet() {
        if (this.omitElementCloseSet == null) {
            this.omitElementCloseSet = new HashSet();
            this.loadOmitElementCloseSet(this.omitElementCloseSet);
        }
        return this.omitElementCloseSet;
    }

    protected void loadOmitElementCloseSet(Set set) {
        set.add("AREA");
        set.add("BASE");
        set.add("BR");
        set.add("COL");
        set.add("HR");
        set.add("IMG");
        set.add("INPUT");
        set.add("LINK");
        set.add("META");
        set.add("P");
        set.add("PARAM");
    }

    public Set getOmitElementCloseSet() {
        return (Set)this.internalGetOmitElementCloseSet().clone();
    }

    public void setOmitElementCloseSet(Set set) {
        this.omitElementCloseSet = new HashSet();
        if (set != null) {
            this.omitElementCloseSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                this.omitElementCloseSet.add(e.toString().toUpperCase());
            }
        }
    }

    public Set getPreformattedTags() {
        return (Set)this.preformattedTags.clone();
    }

    public void setPreformattedTags(Set set) {
        this.preformattedTags = new HashSet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                this.preformattedTags.add(e.toString().toUpperCase());
            }
        }
    }

    public boolean isPreformattedTag(String string) {
        return this.preformattedTags != null && this.preformattedTags.contains(string.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeElement(Element element) throws IOException {
        block6: {
            if (this.newLineAfterNTags == -1) {
                this.lazyInitNewLinesAfterNTags();
            }
            if (this.newLineAfterNTags > 0 && this.tagsOuput > 0 && this.tagsOuput % this.newLineAfterNTags == 0) {
                this.writer.write(lineSeparator);
            }
            ++this.tagsOuput;
            String string = element.getQualifiedName();
            String string2 = this.lastText;
            int n = element.nodeCount();
            if (this.isPreformattedTag(string)) {
                OutputFormat outputFormat = this.getOutputFormat();
                boolean bl = outputFormat.isNewlines();
                boolean bl2 = outputFormat.isTrimText();
                String string3 = outputFormat.getIndent();
                this.formatStack.push(new FormatState(bl, bl2, string3));
                try {
                    super.writePrintln();
                    if (string2.trim().length() == 0 && string3 != null && string3.length() > 0) {
                        this.writer.write(this.justSpaces(string2));
                    }
                    outputFormat.setNewlines(false);
                    outputFormat.setTrimText(false);
                    outputFormat.setIndent("");
                    super.writeElement(element);
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    FormatState formatState = (FormatState)this.formatStack.pop();
                    outputFormat.setNewlines(formatState.isNewlines());
                    outputFormat.setTrimText(formatState.isTrimText());
                    outputFormat.setIndent(formatState.getIndent());
                    throw throwable;
                }
                FormatState formatState = (FormatState)this.formatStack.pop();
                outputFormat.setNewlines(formatState.isNewlines());
                outputFormat.setTrimText(formatState.isTrimText());
                outputFormat.setIndent(formatState.getIndent());
                {
                    break block6;
                }
            }
            super.writeElement(element);
        }
    }

    private String justSpaces(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void lazyInitNewLinesAfterNTags() {
        this.newLineAfterNTags = this.getOutputFormat().isNewlines() ? 0 : this.getOutputFormat().getNewLineAfterNTags();
    }

    public static String prettyPrintHTML(String string) throws IOException, UnsupportedEncodingException, DocumentException {
        return HTMLWriter.prettyPrintHTML(string, true, true, false, true);
    }

    public static String prettyPrintXHTML(String string) throws IOException, UnsupportedEncodingException, DocumentException {
        return HTMLWriter.prettyPrintHTML(string, true, true, true, false);
    }

    public static String prettyPrintHTML(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, UnsupportedEncodingException, DocumentException {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setNewlines(bl);
        outputFormat.setTrimText(bl2);
        outputFormat.setXHTML(bl3);
        outputFormat.setExpandEmptyElements(bl4);
        HTMLWriter hTMLWriter = new HTMLWriter(stringWriter, outputFormat);
        Document document = DocumentHelper.parseText(string);
        hTMLWriter.write(document);
        hTMLWriter.flush();
        return stringWriter.toString();
    }

    static {
        DEFAULT_PREFORMATTED_TAGS.add("PRE");
        DEFAULT_PREFORMATTED_TAGS.add("SCRIPT");
        DEFAULT_PREFORMATTED_TAGS.add("STYLE");
        DEFAULT_PREFORMATTED_TAGS.add("TEXTAREA");
        DEFAULT_HTML_FORMAT = new OutputFormat("  ", true);
        DEFAULT_HTML_FORMAT.setTrimText(true);
        DEFAULT_HTML_FORMAT.setSuppressDeclaration(true);
    }

    private class FormatState {
        private boolean newlines = false;
        private boolean trimText = false;
        private String indent = "";

        public FormatState(boolean bl, boolean bl2, String string) {
            this.newlines = bl;
            this.trimText = bl2;
            this.indent = string;
        }

        public boolean isNewlines() {
            return this.newlines;
        }

        public boolean isTrimText() {
            return this.trimText;
        }

        public String getIndent() {
            return this.indent;
        }
    }
}

