/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private static final String PAD_TEXT = " ";
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    private boolean resolveEntityRefs = true;
    protected int lastOutputNodeType;
    private boolean lastElementClosed = false;
    protected boolean preserve = false;
    protected Writer writer;
    private NamespaceStack namespaceStack = new NamespaceStack();
    private OutputFormat format;
    private boolean escapeText = true;
    private int indentLevel = 0;
    private StringBuffer buffer = new StringBuffer();
    private boolean charsAdded = false;
    private char lastChar;
    private boolean autoFlush;
    private LexicalHandler lexicalHandler;
    private boolean showCommentsInDTDs;
    private boolean inDTD;
    private Map namespacesMap;
    private int maximumAllowedCharacter;

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat outputFormat) {
        this.writer = writer;
        this.format = outputFormat;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter() {
        this.format = DEFAULT_FORMAT;
        this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        this.format = outputFormat;
        this.writer = this.createWriter(outputStream, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputFormat outputFormat) throws UnsupportedEncodingException {
        this.format = outputFormat;
        this.writer = this.createWriter(System.out, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.autoFlush = false;
    }

    public void setOutputStream(OutputStream outputStream) throws UnsupportedEncodingException {
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean bl) {
        this.escapeText = bl;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public int getMaximumAllowedCharacter() {
        if (this.maximumAllowedCharacter == 0) {
            this.maximumAllowedCharacter = this.defaultMaximumAllowedCharacter();
        }
        return this.maximumAllowedCharacter;
    }

    public void setMaximumAllowedCharacter(int n) {
        this.maximumAllowedCharacter = n;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void println() throws IOException {
        this.writer.write(this.format.getLineSeparator());
    }

    public void write(Attribute attribute) throws IOException {
        this.writeAttribute(attribute);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Document document) throws IOException {
        this.writeDeclaration();
        if (document.getDocType() != null) {
            this.indent();
            this.writeDocType(document.getDocType());
        }
        int n = document.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = document.node(i);
            this.writeNode(node);
        }
        this.writePrintln();
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Element element) throws IOException {
        this.writeElement(element);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(CDATA cDATA) throws IOException {
        this.writeCDATA(cDATA.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Comment comment) throws IOException {
        this.writeComment(comment.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(DocumentType documentType) throws IOException {
        this.writeDocType(documentType);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Entity entity) throws IOException {
        this.writeEntity(entity);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Namespace namespace) throws IOException {
        this.writeNamespace(namespace);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws IOException {
        this.writeProcessingInstruction(processingInstruction);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(String string) throws IOException {
        this.writeString(string);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Text text) throws IOException {
        this.writeString(text.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Node node) throws IOException {
        this.writeNode(node);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Object object) throws IOException {
        if (object instanceof Node) {
            this.write((Node)object);
        } else if (object instanceof String) {
            this.write((String)object);
        } else if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.write(list.get(i));
            }
        } else if (object != null) {
            throw new IOException("Invalid object: " + object);
        }
    }

    public void writeOpen(Element element) throws IOException {
        this.writer.write("<");
        this.writer.write(element.getQualifiedName());
        this.writeAttributes(element);
        this.writer.write(">");
    }

    public void writeClose(Element element) throws IOException {
        this.writeClose(element.getQualifiedName());
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.installLexicalHandler();
        super.parse(inputSource);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(string)) continue;
            this.setLexicalHandler((LexicalHandler)object);
            return;
        }
        super.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(string)) continue;
            return this.getLexicalHandler();
        }
        return super.getProperty(string);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (lexicalHandler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            this.writeDeclaration();
            super.startDocument();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.autoFlush) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.namespacesMap == null) {
            this.namespacesMap = new HashMap();
        }
        this.namespacesMap.put(string, string2);
        super.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.charsAdded = false;
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(string3);
            this.writeNamespaces();
            this.writeAttributes(attributes);
            this.writer.write(">");
            ++this.indentLevel;
            this.lastOutputNodeType = 1;
            this.lastElementClosed = false;
            super.startElement(string, string2, string3, attributes);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            boolean bl;
            this.charsAdded = false;
            --this.indentLevel;
            if (this.lastElementClosed) {
                this.writePrintln();
                this.indent();
            }
            if (bl = true) {
                this.writeClose(string3);
            } else {
                this.writeEmptyElementClose(string3);
            }
            this.lastOutputNodeType = 1;
            this.lastElementClosed = true;
            super.endElement(string, string2, string3);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (cArray == null || cArray.length == 0 || n2 <= 0) {
            return;
        }
        try {
            String string = String.valueOf(cArray, n, n2);
            if (this.escapeText) {
                string = this.escapeElementEntities(string);
            }
            if (this.format.isTrimText()) {
                if (this.lastOutputNodeType == 3 && !this.charsAdded) {
                    this.writer.write(32);
                } else if (this.charsAdded && Character.isWhitespace(this.lastChar)) {
                    this.writer.write(32);
                } else if (this.lastOutputNodeType == 1 && this.format.isPadText() && this.lastElementClosed && Character.isWhitespace(cArray[0])) {
                    this.writer.write(PAD_TEXT);
                }
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    this.writer.write(string2);
                    this.writer.write(stringTokenizer.nextToken());
                    string2 = PAD_TEXT;
                }
            } else {
                this.writer.write(string);
            }
            this.charsAdded = true;
            this.lastChar = cArray[n + n2 - 1];
            this.lastOutputNodeType = 3;
            super.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        super.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.indent();
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(PAD_TEXT);
            this.writer.write(string2);
            this.writer.write("?>");
            this.writePrintln();
            this.lastOutputNodeType = 7;
            super.processingInstruction(string, string2);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        super.notationDecl(string, string2, string3);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
        try {
            this.writeDocType(string, string2, string3);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        try {
            this.writer.write("]]>");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void startEntity(String string) throws SAXException {
        try {
            this.writeEntityRef(string);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(string);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.showCommentsInDTDs || !this.inDTD) {
            try {
                this.charsAdded = false;
                this.writeComment(new String(cArray, n, n2));
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    protected void writeElement(Element element) throws IOException {
        int n = element.nodeCount();
        String string = element.getQualifiedName();
        this.writePrintln();
        this.indent();
        this.writer.write("<");
        this.writer.write(string);
        int n2 = this.namespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (this.isNamespaceDeclaration(namespace)) {
            this.namespaceStack.push(namespace);
            this.writeNamespace(namespace);
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Node node = element.node(i);
            if (node instanceof Namespace) {
                Namespace namespace2 = (Namespace)node;
                if (!this.isNamespaceDeclaration(namespace2)) continue;
                this.namespaceStack.push(namespace2);
                this.writeNamespace(namespace2);
                continue;
            }
            if (node instanceof Element) {
                bl = false;
                continue;
            }
            if (!(node instanceof Comment)) continue;
            bl = false;
        }
        this.writeAttributes(element);
        this.lastOutputNodeType = 1;
        if (n <= 0) {
            this.writeEmptyElementClose(string);
        } else {
            this.writer.write(">");
            if (bl) {
                this.writeElementContent(element);
            } else {
                ++this.indentLevel;
                this.writeElementContent(element);
                --this.indentLevel;
                this.writePrintln();
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(string);
            this.writer.write(">");
        }
        while (this.namespaceStack.size() > n2) {
            this.namespaceStack.pop();
        }
        this.lastOutputNodeType = 1;
    }

    protected final boolean isElementSpacePreserved(Element element) {
        Attribute attribute = element.attribute("space");
        boolean bl = this.preserve;
        if (attribute != null) {
            bl = "xml".equals(attribute.getNamespacePrefix()) && "preserve".equals(attribute.getText());
        }
        return bl;
    }

    protected void writeElementContent(Element element) throws IOException {
        boolean bl = this.format.isTrimText();
        boolean bl2 = this.preserve;
        if (bl) {
            this.preserve = this.isElementSpacePreserved(element);
            boolean bl3 = bl = !this.preserve;
        }
        if (bl) {
            char c;
            Node node = null;
            StringBuffer stringBuffer = null;
            boolean bl4 = true;
            char c2 = element.nodeCount();
            for (c = '\u0000'; c < c2; ++c) {
                char c3;
                Node node2 = element.node(c);
                if (node2 instanceof Text) {
                    if (node == null) {
                        node = (Text)node2;
                        continue;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(node.getText());
                    }
                    stringBuffer.append(((Text)node2).getText());
                    continue;
                }
                if (!bl4 && this.format.isPadText()) {
                    c3 = 'a';
                    if (stringBuffer != null) {
                        c3 = stringBuffer.charAt(0);
                    } else if (node != null) {
                        c3 = node.getText().charAt(0);
                    }
                    if (Character.isWhitespace(c3)) {
                        this.writer.write(PAD_TEXT);
                    }
                }
                if (node != null) {
                    if (stringBuffer != null) {
                        this.writeString(stringBuffer.toString());
                        stringBuffer = null;
                    } else {
                        this.writeString(node.getText());
                    }
                    if (this.format.isPadText()) {
                        c3 = 'a';
                        if (stringBuffer != null) {
                            c3 = stringBuffer.charAt(stringBuffer.length() - 1);
                        } else if (node != null) {
                            String string = node.getText();
                            c3 = string.charAt(string.length() - 1);
                        }
                        if (Character.isWhitespace(c3)) {
                            this.writer.write(PAD_TEXT);
                        }
                    }
                    node = null;
                }
                bl4 = false;
                this.writeNode(node2);
            }
            if (node != null) {
                if (!bl4 && this.format.isPadText()) {
                    c = 'a';
                    c = stringBuffer != null ? (char)stringBuffer.charAt(0) : (char)node.getText().charAt(0);
                    if (Character.isWhitespace(c)) {
                        this.writer.write(PAD_TEXT);
                    }
                }
                if (stringBuffer != null) {
                    this.writeString(stringBuffer.toString());
                    stringBuffer = null;
                } else {
                    this.writeString(node.getText());
                }
                node = null;
            }
        } else {
            Node node = null;
            int n = element.nodeCount();
            for (int i = 0; i < n; ++i) {
                String string;
                char c;
                Node node3 = element.node(i);
                if (node3 instanceof Text) {
                    this.writeNode(node3);
                    node = node3;
                    continue;
                }
                if (node != null && this.format.isPadText() && Character.isWhitespace(c = (string = node.getText()).charAt(string.length() - 1))) {
                    this.writer.write(PAD_TEXT);
                }
                this.writeNode(node3);
                node = null;
            }
        }
        this.preserve = bl2;
    }

    protected void writeCDATA(String string) throws IOException {
        this.writer.write("<![CDATA[");
        if (string != null) {
            this.writer.write(string);
        }
        this.writer.write("]]>");
        this.lastOutputNodeType = 4;
    }

    protected void writeDocType(DocumentType documentType) throws IOException {
        if (documentType != null) {
            documentType.write(this.writer);
            this.writePrintln();
        }
    }

    protected void writeNamespace(Namespace namespace) throws IOException {
        if (namespace != null) {
            this.writeNamespace(namespace.getPrefix(), namespace.getURI());
        }
    }

    protected void writeNamespaces() throws IOException {
        if (this.namespacesMap != null) {
            Iterator iterator = this.namespacesMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                this.writeNamespace(string, string2);
            }
            this.namespacesMap = null;
        }
    }

    protected void writeNamespace(String string, String string2) throws IOException {
        if (string != null && string.length() > 0) {
            this.writer.write(" xmlns:");
            this.writer.write(string);
            this.writer.write("=\"");
        } else {
            this.writer.write(" xmlns=\"");
        }
        this.writer.write(string2);
        this.writer.write("\"");
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getName());
        this.writer.write(PAD_TEXT);
        this.writer.write(processingInstruction.getText());
        this.writer.write("?>");
        this.writePrintln();
        this.lastOutputNodeType = 7;
    }

    protected void writeString(String string) throws IOException {
        if (string != null && string.length() > 0) {
            if (this.escapeText) {
                string = this.escapeElementEntities(string);
            }
            if (this.format.isTrimText()) {
                boolean bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (bl) {
                        bl = false;
                        if (this.lastOutputNodeType == 3) {
                            this.writer.write(PAD_TEXT);
                        }
                    } else {
                        this.writer.write(PAD_TEXT);
                    }
                    this.writer.write(string2);
                    this.lastOutputNodeType = 3;
                    this.lastChar = string2.charAt(string2.length() - 1);
                }
            } else {
                this.lastOutputNodeType = 3;
                this.writer.write(string);
                this.lastChar = string.charAt(string.length() - 1);
            }
        }
    }

    protected void writeNodeText(Node node) throws IOException {
        String string = node.getText();
        if (string != null && string.length() > 0) {
            if (this.escapeText) {
                string = this.escapeElementEntities(string);
            }
            this.lastOutputNodeType = 3;
            this.writer.write(string);
            this.lastChar = string.charAt(string.length() - 1);
        }
    }

    protected void writeNode(Node node) throws IOException {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                break;
            }
            case 3: {
                this.writeNodeText(node);
                break;
            }
            case 4: {
                this.writeCDATA(node.getText());
                break;
            }
            case 5: {
                this.writeEntity((Entity)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.writeComment(node.getText());
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new IOException("Invalid node type: " + node);
            }
        }
    }

    protected void installLexicalHandler() {
        XMLReader xMLReader = this.getParent();
        if (xMLReader == null) {
            throw new NullPointerException("No parent for filter");
        }
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            try {
                xMLReader.setProperty(LEXICAL_HANDLER_NAMES[i], this);
                break;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                continue;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
        }
    }

    protected void writeDocType(String string, String string2, String string3) throws IOException {
        boolean bl = false;
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        if (string2 != null && !string2.equals("")) {
            this.writer.write(" PUBLIC \"");
            this.writer.write(string2);
            this.writer.write("\"");
            bl = true;
        }
        if (string3 != null && !string3.equals("")) {
            if (!bl) {
                this.writer.write(" SYSTEM");
            }
            this.writer.write(" \"");
            this.writer.write(string3);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writePrintln();
    }

    protected void writeEntity(Entity entity) throws IOException {
        if (!this.resolveEntityRefs()) {
            this.writeEntityRef(entity.getName());
        } else {
            this.writer.write(entity.getText());
        }
    }

    protected void writeEntityRef(String string) throws IOException {
        this.writer.write("&");
        this.writer.write(string);
        this.writer.write(";");
        this.lastOutputNodeType = 5;
    }

    protected void writeComment(String string) throws IOException {
        if (this.format.isNewlines()) {
            this.println();
            this.indent();
        }
        this.writer.write("<!--");
        this.writer.write(string);
        this.writer.write("-->");
        this.lastOutputNodeType = 8;
    }

    protected void writeAttributes(Element element) throws IOException {
        int n = element.attributeCount();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            Attribute attribute = element.attribute(i);
            Namespace namespace = attribute.getNamespace();
            if (namespace != null && namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                string2 = namespace.getPrefix();
                string = this.namespaceStack.getURI(string2);
                if (!namespace.getURI().equals(string)) {
                    this.writeNamespace(namespace);
                    this.namespaceStack.push(namespace);
                }
            }
            if ((string2 = attribute.getName()).startsWith("xmlns:")) {
                string = string2.substring(6);
                if (this.namespaceStack.getNamespaceForPrefix(string) != null) continue;
                String string3 = attribute.getValue();
                this.namespaceStack.push(string, string3);
                this.writeNamespace(string, string3);
                continue;
            }
            if (string2.equals("xmlns")) {
                if (this.namespaceStack.getDefaultNamespace() != null) continue;
                string = attribute.getValue();
                this.namespaceStack.push(null, string);
                this.writeNamespace(null, string);
                continue;
            }
            char c = this.format.getAttributeQuoteCharacter();
            this.writer.write(PAD_TEXT);
            this.writer.write(attribute.getQualifiedName());
            this.writer.write("=");
            this.writer.write(c);
            this.writeEscapeAttributeEntities(attribute.getValue());
            this.writer.write(c);
        }
    }

    protected void writeAttribute(Attribute attribute) throws IOException {
        this.writer.write(PAD_TEXT);
        this.writer.write(attribute.getQualifiedName());
        this.writer.write("=");
        char c = this.format.getAttributeQuoteCharacter();
        this.writer.write(c);
        this.writeEscapeAttributeEntities(attribute.getValue());
        this.writer.write(c);
        this.lastOutputNodeType = 2;
    }

    protected void writeAttributes(Attributes attributes) throws IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.writeAttribute(attributes, i);
        }
    }

    protected void writeAttribute(Attributes attributes, int n) throws IOException {
        char c = this.format.getAttributeQuoteCharacter();
        this.writer.write(PAD_TEXT);
        this.writer.write(attributes.getQName(n));
        this.writer.write("=");
        this.writer.write(c);
        this.writeEscapeAttributeEntities(attributes.getValue(n));
        this.writer.write(c);
    }

    protected void indent() throws IOException {
        String string = this.format.getIndent();
        if (string != null && string.length() > 0) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(string);
            }
        }
    }

    protected void writePrintln() throws IOException {
        String string;
        if (this.format.isNewlines() && this.lastChar != (string = this.format.getLineSeparator()).charAt(string.length() - 1)) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected Writer createWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(outputStream, string));
    }

    protected void writeDeclaration() throws IOException {
        String string = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (string.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + string + "\"");
                }
                this.writer.write("?>");
            }
            if (this.format.isNewLineAfterDeclaration()) {
                this.println();
            }
        }
    }

    protected void writeClose(String string) throws IOException {
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">");
    }

    protected void writeEmptyElementClose(String string) throws IOException {
        if (!this.format.isExpandEmptyElements()) {
            this.writer.write("/>");
        } else {
            this.writer.write("></");
            this.writer.write(string);
            this.writer.write(">");
        }
    }

    protected boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected String escapeElementEntities(String string) {
        String string2;
        int n;
        char[] cArray = null;
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            string2 = null;
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    if (!this.preserve) break;
                    string2 = String.valueOf(c);
                    break;
                }
                default: {
                    if (c >= ' ' && !this.shouldEncodeChar(c)) break;
                    string2 = "&#" + c + ";";
                }
            }
            if (string2 == null) continue;
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n2, n - n2);
            this.buffer.append(string2);
            n2 = n + 1;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < n3) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n2, n - n2);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    protected void writeEscapeAttributeEntities(String string) throws IOException {
        if (string != null) {
            String string2 = this.escapeAttributeEntities(string);
            this.writer.write(string2);
        }
    }

    protected String escapeAttributeEntities(String string) {
        String string2;
        int n;
        char c = this.format.getAttributeQuoteCharacter();
        char[] cArray = null;
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            string2 = null;
            char c2 = string.charAt(n);
            switch (c2) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\'': {
                    if (c != '\'') break;
                    string2 = "&apos;";
                    break;
                }
                case '\"': {
                    if (c != '\"') break;
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (c2 >= ' ' && !this.shouldEncodeChar(c2)) break;
                    string2 = "&#" + c2 + ";";
                }
            }
            if (string2 == null) continue;
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n2, n - n2);
            this.buffer.append(string2);
            n2 = n + 1;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < n3) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n2, n - n2);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    protected boolean shouldEncodeChar(char c) {
        int n = this.getMaximumAllowedCharacter();
        return n > 0 && c > n;
    }

    protected int defaultMaximumAllowedCharacter() {
        String string = this.format.getEncoding();
        if (string != null && string.equals("US-ASCII")) {
            return 127;
        }
        return -1;
    }

    protected boolean isNamespaceDeclaration(Namespace namespace) {
        String string;
        return namespace != null && namespace != Namespace.XML_NAMESPACE && (string = namespace.getURI()) != null && !this.namespaceStack.contains(namespace);
    }

    protected void handleException(IOException iOException) throws SAXException {
        throw new SAXException(iOException);
    }

    protected OutputFormat getOutputFormat() {
        return this.format;
    }

    public boolean resolveEntityRefs() {
        return this.resolveEntityRefs;
    }

    public void setResolveEntityRefs(boolean bl) {
        this.resolveEntityRefs = bl;
    }
}

