/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Mode;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;
import org.dom4j.rule.pattern.NodeTypePattern;

public class RuleManager {
    private HashMap modes = new HashMap();
    private int appearenceCount;
    private Action valueOfAction;

    public Mode getMode(String string) {
        Mode mode = (Mode)this.modes.get(string);
        if (mode == null) {
            mode = this.createMode();
            this.modes.put(string, mode);
        }
        return mode;
    }

    public void addRule(Rule rule) {
        rule.setAppearenceCount(++this.appearenceCount);
        Mode mode = this.getMode(rule.getMode());
        Rule[] ruleArray = rule.getUnionRules();
        if (ruleArray != null) {
            int n = ruleArray.length;
            for (int i = 0; i < n; ++i) {
                mode.addRule(ruleArray[i]);
            }
        } else {
            mode.addRule(rule);
        }
    }

    public void removeRule(Rule rule) {
        Mode mode = this.getMode(rule.getMode());
        Rule[] ruleArray = rule.getUnionRules();
        if (ruleArray != null) {
            int n = ruleArray.length;
            for (int i = 0; i < n; ++i) {
                mode.removeRule(ruleArray[i]);
            }
        } else {
            mode.removeRule(rule);
        }
    }

    public Rule getMatchingRule(String string, Node node) {
        Mode mode = (Mode)this.modes.get(string);
        if (mode != null) {
            return mode.getMatchingRule(node);
        }
        System.out.println("Warning: No Mode for mode: " + mode);
        return null;
    }

    public void clear() {
        this.modes.clear();
        this.appearenceCount = 0;
    }

    public Action getValueOfAction() {
        return this.valueOfAction;
    }

    public void setValueOfAction(Action action) {
        this.valueOfAction = action;
    }

    protected Mode createMode() {
        Mode mode = new Mode();
        this.addDefaultRules(mode);
        return mode;
    }

    protected void addDefaultRules(final Mode mode) {
        Action action = new Action(){

            public void run(Node node) throws Exception {
                if (node instanceof Element) {
                    mode.applyTemplates((Element)node);
                } else if (node instanceof Document) {
                    mode.applyTemplates((Document)node);
                }
            }
        };
        Action action2 = this.getValueOfAction();
        this.addDefaultRule(mode, NodeTypePattern.ANY_DOCUMENT, action);
        this.addDefaultRule(mode, NodeTypePattern.ANY_ELEMENT, action);
        if (action2 != null) {
            this.addDefaultRule(mode, NodeTypePattern.ANY_ATTRIBUTE, action2);
            this.addDefaultRule(mode, NodeTypePattern.ANY_TEXT, action2);
        }
    }

    protected void addDefaultRule(Mode mode, Pattern pattern, Action action) {
        Rule rule = this.createDefaultRule(pattern, action);
        mode.addRule(rule);
    }

    protected Rule createDefaultRule(Pattern pattern, Action action) {
        Rule rule = new Rule(pattern, action);
        rule.setImportPrecedence(-1);
        return rule;
    }
}

