/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.dom4j.Branch;
import org.dom4j.CharacterData;
import org.dom4j.Node;
import org.dom4j.swing.LeafTreeNode;

public class BranchTreeNode
extends LeafTreeNode {
    protected List children;

    public BranchTreeNode() {
    }

    public BranchTreeNode(Branch branch) {
        super(branch);
    }

    public BranchTreeNode(TreeNode treeNode, Branch branch) {
        super(treeNode, branch);
    }

    public Enumeration children() {
        return new Enumeration(){
            private int index = -1;

            public boolean hasMoreElements() {
                return this.index + 1 < BranchTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return BranchTreeNode.this.getChildAt(++this.index);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.getChildList().get(n);
    }

    public int getChildCount() {
        return this.getChildList().size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.getChildList().indexOf(treeNode);
    }

    public boolean isLeaf() {
        return this.getXmlBranch().nodeCount() <= 0;
    }

    public String toString() {
        return this.xmlNode.getName();
    }

    protected List getChildList() {
        if (this.children == null) {
            this.children = this.createChildList();
        }
        return this.children;
    }

    protected List createChildList() {
        Branch branch = this.getXmlBranch();
        int n = branch.nodeCount();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(n);
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = branch.node(i);
            if (node instanceof CharacterData && ((string = node.getText()) == null || (string = string.trim()).length() <= 0)) continue;
            arrayList.add(this.createChildTreeNode(node));
        }
        return arrayList;
    }

    protected TreeNode createChildTreeNode(Node node) {
        if (node instanceof Branch) {
            return new BranchTreeNode((TreeNode)this, (Branch)node);
        }
        return new LeafTreeNode(this, node);
    }

    protected Branch getXmlBranch() {
        return (Branch)this.xmlNode;
    }
}

