/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;

public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final int DEFAULT_CONTENT_LIST_SIZE = 5;

    public boolean isReadOnly() {
        return false;
    }

    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    public List content() {
        List list = this.contentList();
        return new ContentListFacade(this, list);
    }

    public String getText() {
        int n;
        List list = this.contentList();
        if (list != null && (n = list.size()) >= 1) {
            Object e = list.get(0);
            String string = this.getContentAsText(e);
            if (n == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 1; i < n; ++i) {
                Object e2 = list.get(i);
                stringBuffer.append(this.getContentAsText(e2));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    protected String getContentAsText(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return node.getText();
                }
            }
        } else if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    protected String getContentAsStringValue(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return node.getStringValue();
                }
            }
        } else if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    public String getTextTrim() {
        String string = this.getText();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void setProcessingInstructions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)iterator.next();
            this.addNode(processingInstruction);
        }
    }

    public Element addElement(String string) {
        Element element = this.getDocumentFactory().createElement(string);
        this.add(element);
        return element;
    }

    public Element addElement(String string, String string2) {
        Element element = this.getDocumentFactory().createElement(string, string2);
        this.add(element);
        return element;
    }

    public Element addElement(QName qName) {
        Element element = this.getDocumentFactory().createElement(qName);
        this.add(element);
        return element;
    }

    public Element addElement(String string, String string2, String string3) {
        Namespace namespace = Namespace.get(string2, string3);
        QName qName = this.getDocumentFactory().createQName(string, namespace);
        return this.addElement(qName);
    }

    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.add((Element)node);
                break;
            }
            case 8: {
                this.add((Comment)node);
                break;
            }
            case 7: {
                this.add((ProcessingInstruction)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.remove((Element)node);
            }
            case 8: {
                return this.remove((Comment)node);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node);
            }
        }
        this.invalidNodeTypeAddException(node);
        return false;
    }

    public void add(Comment comment) {
        this.addNode(comment);
    }

    public void add(Element element) {
        this.addNode(element);
    }

    public void add(ProcessingInstruction processingInstruction) {
        this.addNode(processingInstruction);
    }

    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    public boolean remove(ProcessingInstruction processingInstruction) {
        return this.removeNode(processingInstruction);
    }

    public Element elementByID(String string) {
        int n = this.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = this.node(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String string2 = this.elementID(element);
            if (string2 != null && string2.equals(string)) {
                return element;
            }
            if ((element = element.elementByID(string)) == null) continue;
            return element;
        }
        return null;
    }

    public void appendContent(Branch branch) {
        int n = branch.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = branch.node(i);
            this.add((Node)node.clone());
        }
    }

    public Node node(int n) {
        Object e = this.contentList().get(n);
        if (e instanceof Node) {
            return (Node)e;
        }
        if (e instanceof String) {
            return this.getDocumentFactory().createText(e.toString());
        }
        return null;
    }

    public int nodeCount() {
        return this.contentList().size();
    }

    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    public Iterator nodeIterator() {
        return this.contentList().iterator();
    }

    protected String elementID(Element element) {
        return element.attributeValue("ID");
    }

    protected abstract List contentList();

    protected List createContentList() {
        return new ArrayList(5);
    }

    protected List createContentList(int n) {
        return new ArrayList(n);
    }

    protected BackedList createResultList() {
        return new BackedList(this, this.contentList());
    }

    protected List createSingleResultList(Object object) {
        BackedList backedList = new BackedList(this, this.contentList(), 1);
        backedList.addLocal(object);
        return backedList;
    }

    protected List createEmptyList() {
        return new BackedList(this, this.contentList(), 0);
    }

    protected abstract void addNode(Node var1);

    protected abstract void addNode(int var1, Node var2);

    protected abstract boolean removeNode(Node var1);

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    protected void contentRemoved() {
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Node)) continue;
            this.childRemoved((Node)e);
        }
    }

    protected void invalidNodeTypeAddException(Node node) {
        throw new IllegalAddException("Invalid node type. Cannot add node: " + node + " to this branch: " + this);
    }
}

