/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.tree.AbstractDocument;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.xml.sax.EntityResolver;

public class DefaultDocument
extends AbstractDocument {
    protected static final List EMPTY_LIST = Collections.EMPTY_LIST;
    protected static final Iterator EMPTY_ITERATOR = EMPTY_LIST.iterator();
    private String name;
    private Element rootElement;
    private List content;
    private DocumentType docType;
    private DocumentFactory documentFactory = DocumentFactory.getInstance();
    private transient EntityResolver entityResolver;

    public DefaultDocument() {
    }

    public DefaultDocument(String string) {
        this.name = string;
    }

    public DefaultDocument(Element element) {
        this.rootElement = element;
    }

    public DefaultDocument(DocumentType documentType) {
        this.docType = documentType;
    }

    public DefaultDocument(Element element, DocumentType documentType) {
        this.rootElement = element;
        this.docType = documentType;
    }

    public DefaultDocument(String string, Element element, DocumentType documentType) {
        this.name = string;
        this.rootElement = element;
        this.docType = documentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public DocumentType getDocType() {
        return this.docType;
    }

    public void setDocType(DocumentType documentType) {
        this.docType = documentType;
    }

    public Document addDocType(String string, String string2, String string3) {
        this.setDocType(this.getDocumentFactory().createDocType(string, string2, string3));
        return this;
    }

    public String getXMLEncoding() {
        return this.encoding;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public Object clone() {
        DefaultDocument defaultDocument = (DefaultDocument)super.clone();
        defaultDocument.rootElement = null;
        defaultDocument.content = null;
        defaultDocument.appendContent(this);
        return defaultDocument;
    }

    public List processingInstructions() {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction)) continue;
            backedList.add(e);
        }
        return backedList;
    }

    public List processingInstructions(String string) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ProcessingInstruction processingInstruction;
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            backedList.add(processingInstruction);
        }
        return backedList;
    }

    public ProcessingInstruction processingInstruction(String string) {
        List list = this.contentList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ProcessingInstruction processingInstruction;
            Object e = list.get(i);
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            return processingInstruction;
        }
        return null;
    }

    public boolean removeProcessingInstruction(String string) {
        List list = this.contentList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction;
            Object e = iterator.next();
            if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e).getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setContent(List list) {
        this.rootElement = null;
        this.contentRemoved();
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        if (list == null) {
            this.content = null;
        } else {
            int n = list.size();
            List list2 = this.createContentList(n);
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (!(e instanceof Node)) continue;
                Node node = (Node)e;
                Document document = node.getDocument();
                if (document != null && document != this) {
                    node = (Node)node.clone();
                }
                if (node instanceof Element) {
                    if (this.rootElement == null) {
                        this.rootElement = (Element)node;
                    } else {
                        throw new IllegalAddException("A document may only contain one root element: " + list);
                    }
                }
                list2.add(node);
                this.childAdded(node);
            }
            this.content = list2;
        }
    }

    public void clearContent() {
        this.contentRemoved();
        this.content = null;
        this.rootElement = null;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected List contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
            if (this.rootElement != null) {
                this.content.add(this.rootElement);
            }
        }
        return this.content;
    }

    protected void addNode(Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String string = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, string);
            }
            this.contentList().add(node);
            this.childAdded(node);
        }
    }

    protected void addNode(int n, Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String string = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, string);
            }
            this.contentList().add(n, node);
            this.childAdded(node);
        }
    }

    protected boolean removeNode(Node node) {
        if (node == this.rootElement) {
            this.rootElement = null;
        }
        if (this.contentList().remove(node)) {
            this.childRemoved(node);
            return true;
        }
        return false;
    }

    protected void rootElementAdded(Element element) {
        this.rootElement = element;
        element.setDocument(this);
    }

    protected DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }
}

