/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NamespaceStack {
    private DocumentFactory documentFactory;
    private ArrayList namespaceStack = new ArrayList();
    private ArrayList namespaceCacheList = new ArrayList();
    private Map currentNamespaceCache;
    private Map rootNamespaceCache = new HashMap();
    private Namespace defaultNamespace;

    public NamespaceStack() {
        this.documentFactory = DocumentFactory.getInstance();
    }

    public NamespaceStack(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void push(Namespace namespace) {
        this.namespaceStack.add(namespace);
        this.namespaceCacheList.add(null);
        this.currentNamespaceCache = null;
        String string = namespace.getPrefix();
        if (string == null || string.length() == 0) {
            this.defaultNamespace = namespace;
        }
    }

    public Namespace pop() {
        return this.remove(this.namespaceStack.size() - 1);
    }

    public int size() {
        return this.namespaceStack.size();
    }

    public void clear() {
        this.namespaceStack.clear();
        this.namespaceCacheList.clear();
        this.rootNamespaceCache.clear();
        this.currentNamespaceCache = null;
    }

    public Namespace getNamespace(int n) {
        return (Namespace)this.namespaceStack.get(n);
    }

    public Namespace getNamespaceForPrefix(String string) {
        if (string == null) {
            string = "";
        }
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace namespace = (Namespace)this.namespaceStack.get(i);
            if (!string.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        return null;
    }

    public String getURI(String string) {
        Namespace namespace = this.getNamespaceForPrefix(string);
        return namespace != null ? namespace.getURI() : null;
    }

    public boolean contains(Namespace namespace) {
        String string = namespace.getPrefix();
        Namespace namespace2 = null;
        namespace2 = string == null || string.length() == 0 ? this.getDefaultNamespace() : this.getNamespaceForPrefix(string);
        if (namespace2 == null) {
            return false;
        }
        if (namespace2 == namespace) {
            return true;
        }
        return namespace.getURI().equals(namespace2.getURI());
    }

    public QName getQName(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = string3;
        } else if (string3 == null) {
            string3 = string2;
        }
        if (string == null) {
            string = "";
        }
        String string4 = "";
        int n = string3.indexOf(":");
        if (n > 0) {
            string4 = string3.substring(0, n);
            if (string2.trim().length() == 0) {
                string2 = string3.substring(n + 1);
            }
        } else if (string2.trim().length() == 0) {
            string2 = string3;
        }
        Namespace namespace = this.createNamespace(string4, string);
        return this.pushQName(string2, string3, namespace, string4);
    }

    public QName getAttributeQName(String string, String string2, String string3) {
        Map map;
        QName qName;
        if (string3 == null) {
            string3 = string2;
        }
        if ((qName = (QName)(map = this.getNamespaceCache()).get(string3)) != null) {
            return qName;
        }
        if (string2 == null) {
            string2 = string3;
        }
        if (string == null) {
            string = "";
        }
        Namespace namespace = null;
        String string4 = "";
        int n = string3.indexOf(":");
        if (n > 0) {
            string4 = string3.substring(0, n);
            namespace = this.createNamespace(string4, string);
            if (string2.trim().length() == 0) {
                string2 = string3.substring(n + 1);
            }
        } else {
            namespace = Namespace.NO_NAMESPACE;
            if (string2.trim().length() == 0) {
                string2 = string3;
            }
        }
        qName = this.pushQName(string2, string3, namespace, string4);
        map.put(string3, qName);
        return qName;
    }

    public void push(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Namespace namespace = this.createNamespace(string, string2);
        this.push(namespace);
    }

    public Namespace addNamespace(String string, String string2) {
        Namespace namespace = this.createNamespace(string, string2);
        this.push(namespace);
        return namespace;
    }

    public Namespace pop(String string) {
        if (string == null) {
            string = "";
        }
        Namespace namespace = null;
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace namespace2 = (Namespace)this.namespaceStack.get(i);
            if (!string.equals(namespace2.getPrefix())) continue;
            this.remove(i);
            namespace = namespace2;
            break;
        }
        if (namespace == null) {
            System.out.println("Warning: missing namespace prefix ignored: " + string);
        }
        return namespace;
    }

    public String toString() {
        return super.toString() + " Stack: " + this.namespaceStack.toString();
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.findDefaultNamespace();
        }
        return this.defaultNamespace;
    }

    protected QName pushQName(String string, String string2, Namespace namespace, String string3) {
        if (string3 == null || string3.length() == 0) {
            this.defaultNamespace = null;
        }
        return this.createQName(string, string2, namespace);
    }

    protected QName createQName(String string, String string2, Namespace namespace) {
        return this.documentFactory.createQName(string, namespace);
    }

    protected Namespace createNamespace(String string, String string2) {
        return this.documentFactory.createNamespace(string, string2);
    }

    protected Namespace findDefaultNamespace() {
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            String string;
            Namespace namespace = (Namespace)this.namespaceStack.get(i);
            if (namespace == null || (string = namespace.getPrefix()) != null && namespace.getPrefix().length() != 0) continue;
            return namespace;
        }
        return null;
    }

    protected Namespace remove(int n) {
        Namespace namespace = (Namespace)this.namespaceStack.remove(n);
        this.namespaceCacheList.remove(n);
        this.defaultNamespace = null;
        this.currentNamespaceCache = null;
        return namespace;
    }

    protected Map getNamespaceCache() {
        if (this.currentNamespaceCache == null) {
            int n = this.namespaceStack.size() - 1;
            if (n < 0) {
                this.currentNamespaceCache = this.rootNamespaceCache;
            } else {
                this.currentNamespaceCache = (Map)this.namespaceCacheList.get(n);
                if (this.currentNamespaceCache == null) {
                    this.currentNamespaceCache = new HashMap();
                    this.namespaceCacheList.set(n, this.currentNamespaceCache);
                }
            }
        }
        return this.currentNamespaceCache;
    }
}

