/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.ArrayList;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.XPathException;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom4j.DocumentNavigator;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.jaxen.saxpath.SAXPathException;

public class XPathPattern
implements org.dom4j.rule.Pattern {
    private String text;
    private Pattern pattern;
    private Context context;

    public XPathPattern(Pattern pattern) {
        this.pattern = pattern;
        this.text = pattern.getText();
        this.context = new Context(this.getContextSupport());
    }

    public XPathPattern(String string) {
        this.text = string;
        this.context = new Context(this.getContextSupport());
        try {
            this.pattern = PatternParser.parse((String)string);
        }
        catch (SAXPathException sAXPathException) {
            throw new InvalidXPathException(string, sAXPathException.getMessage());
        }
        catch (Throwable throwable) {
            throw new InvalidXPathException(string, throwable);
        }
    }

    public boolean matches(Node node) {
        try {
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            this.context.setNodeSet(arrayList);
            return this.pattern.matches((Object)node, this.context);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    public String getText() {
        return this.text;
    }

    public double getPriority() {
        return this.pattern.getPriority();
    }

    public org.dom4j.rule.Pattern[] getUnionPatterns() {
        Pattern[] patternArray = this.pattern.getUnionPatterns();
        if (patternArray != null) {
            int n = patternArray.length;
            org.dom4j.rule.Pattern[] patternArray2 = new XPathPattern[n];
            for (int i = 0; i < n; ++i) {
                patternArray2[i] = new XPathPattern(patternArray[i]);
            }
            return patternArray2;
        }
        return null;
    }

    public short getMatchType() {
        return this.pattern.getMatchType();
    }

    public String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public void setVariableContext(VariableContext variableContext) {
        this.context.getContextSupport().setVariableContext(variableContext);
    }

    public String toString() {
        return "[XPathPattern: text: " + this.text + " Pattern: " + this.pattern + "]";
    }

    protected ContextSupport getContextSupport() {
        return new ContextSupport((NamespaceContext)new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), DocumentNavigator.getInstance());
    }

    protected void handleJaxenException(JaxenException jaxenException) throws XPathException {
        throw new XPathException(this.text, (Exception)((Object)jaxenException));
    }
}

