/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    private static final String LOG_INTERFACE = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactoryImpl.class$("org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) throws LogConfigurationException {
        Log log = (Log)this.instances.get(string);
        if (log == null) {
            log = this.newInstance(string);
            this.instances.put(string, log);
        }
        return log;
    }

    public void release() {
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }

    protected String getLogClassName() {
        if (this.logClassName != null) {
            return this.logClassName;
        }
        this.logClassName = (String)this.getAttribute("org.apache.commons.logging.Log");
        if (this.logClassName == null) {
            this.logClassName = (String)this.getAttribute(LOG_PROPERTY_OLD);
        }
        if (this.logClassName == null) {
            try {
                this.logClassName = System.getProperty("org.apache.commons.logging.Log");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.logClassName == null) {
            try {
                this.logClassName = System.getProperty(LOG_PROPERTY_OLD);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.logClassName == null && this.isLog4JAvailable()) {
            this.logClassName = "org.apache.commons.logging.impl.Log4JLogger";
        }
        if (this.logClassName == null && this.isJdk14Available()) {
            this.logClassName = "org.apache.commons.logging.impl.Jdk14Logger";
        }
        if (this.logClassName == null && this.isJdk13LumberjackAvailable()) {
            this.logClassName = "org.apache.commons.logging.impl.Jdk13LumberjackLogger";
        }
        if (this.logClassName == null) {
            this.logClassName = "org.apache.commons.logging.impl.SimpleLog";
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String string = this.getLogClassName();
        Class clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz2 = this.getClass().getClassLoader().loadClass("org.apache.commons.logging.Log");
            clazz = LogFactoryImpl.loadClass(string);
            if (clazz == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + string);
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    if ("org.apache.commons.logging.Log".equals(classArray[n].getName())) {
                        throw new LogConfigurationException("Invalid class loader hierarchy.  You have more than one version of 'org.apache.commons.logging.Log' visible, which is not allowed.");
                    }
                    ++n;
                }
                throw new LogConfigurationException("Class " + string + " does not implement '" + "org.apache.commons.logging.Log" + "'.");
            }
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
        try {
            this.logMethod = clazz.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable throwable) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = clazz.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + string, throwable);
        }
    }

    private static Class loadClass(final String string) throws ClassNotFoundException {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = LogFactoryImpl.access$001();
                if (classLoader != null) {
                    try {
                        return classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return classNotFoundException;
                }
            }
        });
        if (t instanceof Class) {
            return (Class)t;
        }
        throw (ClassNotFoundException)t;
    }

    protected boolean isJdk13LumberjackAvailable() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Jdk13LumberjackLogger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Jdk14Logger");
            Class clazz = LogFactoryImpl.loadClass("java.lang.Throwable");
            return clazz.getDeclaredMethod("getStackTrace", null) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.apache.log4j.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Log4JLogger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected Log newInstance(String string) throws LogConfigurationException {
        Log log = null;
        try {
            Object[] objectArray = new Object[]{string};
            log = (Log)this.getLogConstructor().newInstance(objectArray);
            if (this.logMethod != null) {
                objectArray[0] = this;
                this.logMethod.invoke((Object)log, objectArray);
            }
            return log;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable != null) {
                throw new LogConfigurationException(throwable);
            }
            throw new LogConfigurationException(invocationTargetException);
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ClassLoader access$001() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }
}

