/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Predicate predicate;

    public BeanPredicate(String string, Predicate predicate) {
        this.propertyName = string;
        this.predicate = predicate;
    }

    public boolean evaluate(Object object) {
        boolean bl = false;
        try {
            Object object2 = PropertyUtils.getProperty(object, this.propertyName);
            bl = this.predicate.evaluate(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Problem during evaluation.";
            this.log.error((Object)"ERROR: Problem during evaluation.", (Throwable)illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Unable to access the property provided.";
            this.log.error((Object)"Unable to access the property provided.", (Throwable)illegalAccessException);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Exception occurred in property's getter";
            this.log.error((Object)"Exception occurred in property's getter", (Throwable)invocationTargetException);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Property not found.";
            this.log.error((Object)"Property not found.", (Throwable)noSuchMethodException);
            throw new IllegalArgumentException("Property not found.");
        }
        return bl;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }
}

