/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueEqualsPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Object propertyValue;
    private boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String string, Object object) {
        this(string, object, false);
    }

    public BeanPropertyValueEqualsPredicate(String string, Object object, boolean bl) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = string;
        this.propertyValue = object;
        this.ignoreNull = bl;
    }

    public boolean evaluate(Object object) {
        boolean bl = false;
        try {
            bl = this.evaluateValue(this.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Problem during evaluation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn((Object)"WARNING: Problem during evaluation. Null value encountered in property path...", (Throwable)illegalArgumentException);
            }
            this.log.error((Object)"ERROR: Problem during evaluation. Null value encountered in property path...", (Throwable)illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Unable to access the property provided.";
            this.log.error((Object)"Unable to access the property provided.", (Throwable)illegalAccessException);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Exception occurred in property's getter";
            this.log.error((Object)"Exception occurred in property's getter", (Throwable)invocationTargetException);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Property not found.";
            this.log.error((Object)"Property not found.", (Throwable)noSuchMethodException);
            throw new IllegalArgumentException("Property not found.");
        }
        return bl;
    }

    private boolean evaluateValue(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

