/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Map;
import java.util.WeakHashMap;

public class ContextClassLoaderLocal {
    private Map valueByClassLoader = new WeakHashMap();
    private boolean globalValueInitialized = false;
    private Object globalValue;

    protected Object initialValue() {
        return null;
    }

    public synchronized Object get() {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                Object object = this.valueByClassLoader.get(classLoader);
                if (object == null && !this.valueByClassLoader.containsKey(classLoader)) {
                    object = this.initialValue();
                    this.valueByClassLoader.put(classLoader, object);
                }
                return object;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!this.globalValueInitialized) {
            this.globalValue = this.initialValue();
            this.globalValueInitialized = true;
        }
        return this.globalValue;
    }

    public synchronized void set(Object object) {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                this.valueByClassLoader.put(classLoader, object);
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.globalValue = object;
        this.globalValueInitialized = true;
    }

    public synchronized void unset() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.unset(classLoader);
        }
        catch (SecurityException securityException) {}
    }

    public synchronized void unset(ClassLoader classLoader) {
        this.valueByClassLoader.remove(classLoader);
    }
}

