/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$ConvertUtils == null ? (class$org$apache$commons$beanutils$ConvertUtils = ConvertUtilsBean.class$("org.apache.commons.beanutils.ConvertUtils")) : class$org$apache$commons$beanutils$ConvertUtils));
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    static /* synthetic */ Class class$org$apache$commons$beanutils$ConvertUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean bl) {
        this.defaultBoolean = new Boolean(bl);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtilsBean.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte by) {
        this.defaultByte = new Byte(by);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char c) {
        this.defaultCharacter = new Character(c);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtilsBean.class$("java.lang.Character")) : class$java$lang$Character);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double d) {
        this.defaultDouble = new Double(d);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float f) {
        this.defaultFloat = new Float(f);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int n) {
        this.defaultInteger = new Integer(n);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long l) {
        this.defaultLong = new Long(l);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short s) {
        defaultShort = new Short(s);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short);
    }

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            if (Array.getLength(object) < 1) {
                return null;
            }
            if ((object = Array.get(object, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
            return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, object);
        }
        Converter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, object);
    }

    public Object convert(String string, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string '" + string + "' to class '" + clazz.getName() + "'"));
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, string);
    }

    public Object convert(String[] stringArray, Class clazz) {
        Converter converter;
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + stringArray.length + "] to class '" + clazz2.getName() + "[]'"));
        }
        if ((converter = this.lookup(clazz2)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Array.set(object, n, converter.convert(clazz2, stringArray[n]));
            ++n;
        }
        return object;
    }

    public void deregister() {
        boolean[] blArray = new boolean[]{};
        byte[] byArray = new byte[]{};
        char[] cArray = new char[]{};
        double[] dArray = new double[]{};
        float[] fArray = new float[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        short[] sArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        this.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalConverter());
        this.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        this.register(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtilsBean.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanConverter(this.defaultBoolean));
        this.register(blArray.getClass(), new BooleanArrayConverter(blArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        this.register(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteConverter(this.defaultByte));
        this.register(byArray.getClass(), new ByteArrayConverter(byArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        this.register(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtilsBean.class$("java.lang.Character")) : class$java$lang$Character, new CharacterConverter(this.defaultCharacter));
        this.register(cArray.getClass(), new CharacterArrayConverter(cArray));
        this.register(class$java$lang$Class == null ? (class$java$lang$Class = ConvertUtilsBean.class$("java.lang.Class")) : class$java$lang$Class, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        this.register(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double, new DoubleConverter(this.defaultDouble));
        this.register(dArray.getClass(), new DoubleArrayConverter(dArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        this.register(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float, new FloatConverter(this.defaultFloat));
        this.register(fArray.getClass(), new FloatArrayConverter(fArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        this.register(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerConverter(this.defaultInteger));
        this.register(nArray.getClass(), new IntegerArrayConverter(nArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        this.register(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long, new LongConverter(this.defaultLong));
        this.register(lArray.getClass(), new LongArrayConverter(lArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        this.register(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short, new ShortConverter(defaultShort));
        this.register(sArray.getClass(), new ShortArrayConverter(sArray));
        this.register(class$java$lang$String == null ? (class$java$lang$String = ConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        this.register(class$java$sql$Date == null ? (class$java$sql$Date = ConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateConverter());
        this.register(class$java$sql$Time == null ? (class$java$sql$Time = ConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time, new SqlTimeConverter());
        this.register(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlTimestampConverter());
        this.register(class$java$io$File == null ? (class$java$io$File = ConvertUtilsBean.class$("java.io.File")) : class$java$io$File, new FileConverter());
        this.register(class$java$net$URL == null ? (class$java$net$URL = ConvertUtilsBean.class$("java.net.URL")) : class$java$net$URL, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

