/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyDynaBean
implements DynaBean,
Serializable {
    private static Log logger = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$LazyDynaBean == null ? (class$org$apache$commons$beanutils$LazyDynaBean = LazyDynaBean.class$("org.apache.commons.beanutils.LazyDynaBean")) : class$org$apache$commons$beanutils$LazyDynaBean));
    protected static final BigInteger BigInteger_ZERO = new BigInteger("0");
    protected static final BigDecimal BigDecimal_ZERO = new BigDecimal("0");
    protected static final Character Character_SPACE = new Character(' ');
    protected static final Byte Byte_ZERO = new Byte(0);
    protected static final Short Short_ZERO = new Short(0);
    protected static final Integer Integer_ZERO = new Integer(0);
    protected static final Long Long_ZERO = new Long(0L);
    protected static final Float Float_ZERO = new Float(0.0f);
    protected static final Double Double_ZERO = new Double(0.0);
    protected Map values = this.newMap();
    protected MutableDynaClass dynaClass;
    static /* synthetic */ Class class$org$apache$commons$beanutils$LazyDynaBean;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaBean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String string) {
        this(new LazyDynaClass(string));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map getMap() {
        return this.values;
    }

    public int size(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v = this.values.get(string);
        if (v == null) {
            return 0;
        }
        if (v instanceof Map) {
            return ((Map)v).size();
        }
        if (v instanceof List) {
            return ((List)v).size();
        }
        if (v.getClass().isArray()) {
            return Array.getLength(v);
        }
        return 0;
    }

    public boolean contains(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v = this.values.get(string);
        if (v == null) {
            return false;
        }
        if (v instanceof Map) {
            return ((Map)v).containsKey(string2);
        }
        return false;
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object object = this.values.get(string);
        if (object != null) {
            return object;
        }
        if (!this.isDynaProperty(string)) {
            return null;
        }
        object = this.createProperty(string, this.dynaClass.getDynaProperty(string).getType());
        if (object != null) {
            this.set(string, object);
        }
        return object;
    }

    public Object get(String string, int n) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]' " + this.dynaClass.getDynaProperty(string).getName());
        }
        if ((object = this.growIndexedProperty(string, object, n)).getClass().isArray()) {
            return Array.get(object, n);
        }
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]' " + object.getClass().getName());
    }

    public Object get(String string, String string2) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")' " + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if (object instanceof Map) {
            return ((Map)object).get(string2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + object.getClass().getName());
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object v = this.values.get(string);
        if (v == null) {
            return;
        }
        if (!(v instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + v.getClass().getName());
        }
        ((Map)v).remove(string2);
    }

    public void set(String string, Object object) {
        if (!this.isDynaProperty(string)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + string + "' (DynaClass is restricted)");
            }
            if (object == null) {
                this.dynaClass.add(string);
            } else {
                this.dynaClass.add(string, object.getClass());
            }
        }
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(string);
        if (object == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + string + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), object.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + object.getClass().getName() + "' to property '" + string + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(string, object);
    }

    public void set(String string, int n, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultIndexedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        if ((object2 = this.growIndexedProperty(string, object2, n)).getClass().isArray()) {
            Array.set(object2, n, object);
        } else if (object2 instanceof List) {
            ((List)object2).set(n, object);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]' " + object2.getClass().getName());
        }
    }

    public void set(String string, String string2, Object object) {
        if (!this.isDynaProperty(string)) {
            this.set(string, this.defaultMappedProperty(string));
        }
        Object object2 = this.get(string);
        if (!this.dynaClass.getDynaProperty(string).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'" + this.dynaClass.getDynaProperty(string).getType().getName());
        }
        ((Map)object2).put(string2, object);
    }

    protected Object growIndexedProperty(String string, Object object, int n) {
        int n2;
        if (object instanceof List) {
            List list = (List)object;
            while (n >= list.size()) {
                list.add(null);
            }
        }
        if (object.getClass().isArray() && n >= (n2 = Array.getLength(object))) {
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = Array.newInstance(clazz, n + 1);
            System.arraycopy(object, 0, object2, 0, n2);
            object = object2;
            this.set(string, object);
            int n3 = Array.getLength(object);
            int n4 = n2;
            while (n4 < n3) {
                Array.set(object, n4, this.createProperty(string + "[" + n4 + "]", clazz));
                ++n4;
            }
        }
        return object;
    }

    protected Object createProperty(String string, Class clazz) {
        if (clazz.isArray() || (class$java$util$List == null ? (class$java$util$List = LazyDynaBean.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            return this.createIndexedProperty(string, clazz);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = LazyDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            return this.createMappedProperty(string, clazz);
        }
        if ((class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = LazyDynaBean.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean).isAssignableFrom(clazz)) {
            return this.createDynaBeanProperty(string, clazz);
        }
        if (clazz.isPrimitive()) {
            return this.createPrimitiveProperty(string, clazz);
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = LazyDynaBean.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
            return this.createNumberProperty(string, clazz);
        }
        return this.createOtherProperty(string, clazz);
    }

    protected Object createIndexedProperty(String string, Class clazz) {
        Object object = null;
        if (clazz == null) {
            object = this.defaultIndexedProperty(string);
        } else if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), 0);
        } else if ((class$java$util$List == null ? (class$java$util$List = LazyDynaBean.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            if (clazz.isInterface()) {
                object = this.defaultIndexedProperty(string);
            } else {
                try {
                    object = clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error instantiating indexed property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
                }
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property of type '" + clazz.getName() + "' for '" + string + "'");
        }
        return object;
    }

    protected Object createMappedProperty(String string, Class clazz) {
        Map map = null;
        if (clazz == null) {
            map = this.defaultMappedProperty(string);
        } else if (clazz.isInterface()) {
            map = this.defaultMappedProperty(string);
        } else if ((class$java$util$Map == null ? (class$java$util$Map = LazyDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            try {
                map = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error instantiating mapped property of type '" + clazz.getName() + "' for '" + string + "' " + exception);
            }
        } else {
            throw new IllegalArgumentException("Non-mapped property of type '" + clazz.getName() + "' for '" + string + "'");
        }
        return map;
    }

    protected Object createDynaBeanProperty(String string, Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Error instantiating DynaBean property of type '" + clazz.getName() + "' for '" + string + "' " + exception));
            }
            return null;
        }
    }

    protected Object createPrimitiveProperty(String string, Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (clazz == Long.TYPE) {
            return Long_ZERO;
        }
        if (clazz == Double.TYPE) {
            return Double_ZERO;
        }
        if (clazz == Float.TYPE) {
            return Float_ZERO;
        }
        if (clazz == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (clazz == Short.TYPE) {
            return Short_ZERO;
        }
        if (clazz == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    protected Object createNumberProperty(String string, Class clazz) {
        return null;
    }

    protected Object createOtherProperty(String string, Class clazz) {
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = LazyDynaBean.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LazyDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = LazyDynaBean.class$("java.lang.Character")) : class$java$lang$Character) || (class$java$util$Date == null ? (class$java$util$Date = LazyDynaBean.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Error instantiating property of type '" + clazz.getName() + "' for '" + string + "' " + exception));
            }
            return null;
        }
    }

    protected Object defaultIndexedProperty(String string) {
        return new ArrayList();
    }

    protected Map defaultMappedProperty(String string) {
        return new HashMap();
    }

    protected boolean isDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(string);
        }
        return this.dynaClass.getDynaProperty(string) != null;
    }

    protected boolean isAssignable(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz == Boolean.TYPE && clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LazyDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Byte.TYPE && clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LazyDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Character.TYPE && clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LazyDynaBean.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Double.TYPE && clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = LazyDynaBean.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Float.TYPE && clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = LazyDynaBean.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Integer.TYPE && clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LazyDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Long.TYPE && clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = LazyDynaBean.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Short.TYPE && clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LazyDynaBean.class$("java.lang.Short")) : class$java$lang$Short);
    }

    protected Map newMap() {
        return new HashMap();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

